import numpy as np
import os
from scipy import constants as const
import math as m
import configparser
#import sys
import copy



class Main_collection():
    def __init__(self,path_to_programm,path_to_control_file): 
        import time
        self.start_time=time.time()
        self.laufzeit=time.time()-self.start_time
        self.path_to_programm=path_to_programm
        self.path_to_control_file=path_to_control_file
        self.insulation_database_directory=self.path_to_programm+'\\Data\\database\\insulationdatabase'        
        self.material_database_director=self.path_to_programm+'\\Data\\database\\materialdatabase' 

        #read control file
        self.read_control_input(self.path_to_control_file)
        self.path_to_machine=self.path_to_programm+'\\Machine_Output\\'+self.machine_name
        self.create_machine_folder()


       
    def read_parameter_file (self,parameter_file):
        #import configparser

        # Open the file in read mode
        file = open(parameter_file, "r")

        # Read each line one by one
        line_count=0
        data=[]
        
        for line in file:
            line_count+=1
            if line_count==1:
                if line.strip()!='[Parameter]':
                    print('Error in reading file: ',parameter_file)
                else:
                    pass           
            elif line.strip()=='':
                pass
                #print(line_count,' is empty')
            else:    
                sep1=line.strip().index('=')
                sep2=line.strip().index(':')                
                name=str(line.strip()[0:sep1].strip())
                value=eval(line.strip()[sep1+1:sep2].strip())
                comment=str(line.strip()[sep2+1::].strip())
                data.append([name,value,comment])
        file.close()
        return data

    def find_parameter_entry (self,data,name):
        data_line=[]
        for i in range(len(data)):            
            if data[i][0]==name:
                data_line=data[i]
                break
        if data_line==[]:
            print('parameter:', name, ' not found!')
        return data_line
        
    def read_control_input(self, parameter_file):
        #read control file
        self.input_data_control=self.read_parameter_file (parameter_file)
        self.standard_machine=self.find_parameter_entry(self.input_data_control,'standard_machine_data')[1]
        self.specific_machine=self.find_parameter_entry(self.input_data_control,'specific_machine_data')[1]
        self.machine_name=self.find_parameter_entry(self.input_data_control,'machine_name')[1]
        self.standard_machine_folder=self.path_to_programm+'\\Data\\standard_machine_data\\'+self.standard_machine
        self.specific_machine_folder=self.path_to_programm+'\\Data\\specific_machine_data\\'+self.specific_machine 

    def create_machine_folder(self):
        if not os.path.exists(self.path_to_machine):
            os.makedirs(self.path_to_machine)        

    def export_data(self,names):
        export_data=[]
        for i in range(len(names)):
            if self.find_parameter_entry(self.input_data_collected,names[i])!=[]:
                export_data.append(self.find_parameter_entry(self.input_data_collected,names[i]))
        return export_data

    def export_all_data(self,prename):
        export_data=copy.deepcopy(self.data_collected)
        for i in range(len(export_data)):
            export_data[i][0]=''.join((str(prename),'_',str(export_data[i][0])))
        return export_data        

    def read_external_input(self,data_pool):
        names_required=self.input_required
        data_exist=self.input_data_collected
        for i in range(len(names_required)):
            if self.find_parameter_entry (data_pool,names_required[i])!=[]:
                data_exist.append(self.find_parameter_entry (data_pool,names_required[i]))

    def read_input_data(self):
        #READ STANDARD/SPECIFIC COIL FILES
        #read standard
        self.input_data_standard_geometry=self.read_parameter_file(self.standard_machine_folder+'\\'+self.class_name+'\\geometry.txt')
        self.input_data_standard_model=self.read_parameter_file(self.standard_machine_folder+'\\'+self.class_name+'\\model.txt')
        #read specific
        self.input_data_specific_geometry=self.read_parameter_file(self.specific_machine_folder+'\\'+self.class_name+'\\geometry.txt')
        self.input_data_specific_model=self.read_parameter_file(self.specific_machine_folder+'\\'+self.class_name+'\\model.txt')
        #control_file already read in       
        #print(self.input_data_control)

        #COLLECT ALL DATA
        #Standard folders
        data_collected=[]
        data_collected.extend(copy.deepcopy(self.input_data_standard_geometry))
        data_collected.extend(copy.deepcopy(self.input_data_standard_model))
        #Specific folders
        data_collected.extend(copy.deepcopy(self.input_data_specific_geometry))
        data_collected.extend(copy.deepcopy(self.input_data_specific_model))            
        #Add control file parameters if already exist
        [data_collected.append(data) for data in self.input_data_control if data[0] in np.transpose(data_collected,axes=None).tolist()[0]]

        #REMOVE DOUBLE ENTRIES
        index_double_entries=[]
        for i in range(len(data_collected)):
            for j in range(len(data_collected)):
                if data_collected[i][0]==data_collected[j][0] and i<j:
                    index_double_entries.append([i,j])
                    break
        for i in range(len(index_double_entries)):
            data_collected.pop(index_double_entries[-(i+1)][0])
       
        self.input_data=data_collected

    def read_class_info_file(self):

        file=self.path_to_programm+'\\Python_Code\\class_'+self.class_name+'\\class_info.txt'       
        file = open(file, "r")

        # Read each line one by one
        line_count=0
        in_parameter_section=0
        #new_section=0
        data_parameter=[]
        data_function=[]
        
        for line in file:
            line_count+=1
            if line_count==1:
                if line.strip()!='[Parameter]':
                    print('Error in reading file: ',file)
                else:
                    in_parameter_section=1
                    pass           
            elif line.strip()=='':
                pass

            elif line.strip()[0]=='[':
                data_function.append([])
                data_function[-1].append(line.strip()[1:-1])           
                in_parameter_section=0
            elif in_parameter_section==0:                   # READ parameter input part  
                sep1=line.strip().index(':')            
                prefix=str(line.strip()[0:sep1].strip())
                name=str(line.strip()[sep1+1::].strip())                                
                data_function[-1].append([prefix,name])           
            elif in_parameter_section==1:                   # READ function input part                                  
                sep_positions=[]
                for i in range(len(line.strip())):
                    if line.strip()[i]==':':
                        sep_positions.append(i)
                if len(sep_positions)!=4:
                    print('error in class_info file')               
                else:
                    #Variable name
                    data_parameter.append([])
                    data_parameter[-1].append(str(line.strip()[0:sep_positions[0]].strip()))
                    #Variable values (min,max,default)                   
                    for i in range(3):
                        low=i
                        high=i+1
                        temp=line.strip()[sep_positions[low]+1:sep_positions[high]].strip()
                        i_sep=temp.index('=')
                        data_parameter[-1].append(eval(temp[i_sep+1::]))                        
                    #Variable description          
                    temp=line.strip()[sep_positions[3]+1::].strip()
                    i_sep=temp.index('=')
                    data_parameter[-1].append(str(temp[i_sep+1::]))               
        file.close()
        self.input_parameter_declaration=data_parameter
        self.input_function_required=data_function   
        return data_parameter,data_function      

    def check_extend_input(self):        
        if len(self.input_parameter_declaration)!=len(self.input_data):
            print('class:',self.class_name,', len() input_parameter_declaration',len(self.input_parameter_declaration),', len() data_collected',len(self.input_data))
        self.data_collected=[]        
        if len(self.input_parameter_declaration)==len(self.input_data) or 0==0:
            for i in range(len(self.input_data)):
                self.data_collected.append(self.input_data[i][0:2])
                try:
                    extension=[temp for temp in self.input_parameter_declaration if temp[0]==self.input_data[i][0]][0][1::]
                except:
                    print('parameter is missing in input_parameter_declaration name:',self.input_data[i][0])
                    extension=[]
                self.data_collected[-1].extend(extension)            
       
    def import_function_data(self,data_pool,function_name):
        data=[]
        input_data_required=[function_data for function_data in self.input_function_required if function_data[0] == function_name][0][1::]
        for i in range(len(input_data_required)):
            name=input_data_required[i][0]+'_'+input_data_required[i][1]
            data.append(self.find_parameter_entry(data_pool,name))
            data[-1][0]=input_data_required[i][1]
        return data

    def create_variables(self,data):
        for i in range(len(data)):
            if data [i][0] not in vars(self):
                vars(self)[data[i][0]]=data[i][1]
        
    def get_material(self,filename):
        cfg = configparser.ConfigParser(inline_comment_prefixes=":")
        cfg.optionxform = lambda option: option
        f=open(self.material_database_director+'\\'+filename+'\\'+filename+'.txt', "r")
        cfg.read(self.material_database_director+'\\'+filename+'\\'+filename+'.txt')
        for Name,Value in cfg.items('Materialparameter'):
            vars(self)['mat_'+filename+'_'+Name]=eval(Value)
        f.close()

    def get_insulation(self,wedge=0,enamel=1):
        self.insulation_database_directory 

        #READ GENERAL DATA INSULATION2.txt
        File='Insulation2.txt'
        file = open(self.insulation_database_directory+'\\'+File, "r")
        # Read each line one by one
        line_count=0
        data=[]       
        for line in file:
            line_count+=1
            if line_count==1:    #description line 1
                data.append([])
                sep=[]
                [sep.append(i) for i in range(len(line)) if line[i]=='-']
                for i in range(len(sep)+1):
                    if i==0:
                        data[-1].append(line[0:sep[i]].strip())                    
                    elif i!=len(sep):
                        data[-1].append(line[sep[i-1]+1:sep[i]].strip())  
                    else:
                        data[-1].append(line[sep[-1]+1::].strip())             
            elif line.strip()=='':
                pass
            elif line.strip()[0]=='#':
                pass
            else:           # data line 2-5               
                data.append([])
                sep=[]
                [sep.append(i) for i in range(len(line)) if line[i]=='-']

                nr_section_values=[1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6]
                section_values_current=0
                section_current=0

                data[-1].append([])
                for i in range(len(sep)+1):                   
                    if section_values_current==nr_section_values[section_current]:
                        data[-1].append([])
                        section_current+=1
                        section_values_current=0
                    if i==0:
                        data[-1][-1].append(eval(line[0:sep[i]].strip()))                    
                    elif i!=len(sep):
                        data[-1][-1].append(eval(line[sep[i-1]+1:sep[i]].strip()))
                    else:    
                        data[-1][-1].append(eval(line[sep[-1]+1::].strip()))
                    section_values_current+=1

        file.close()
        
        data_return=[]
        for i in range(len(data)):
            if data[i][0][0]==wedge and data[i][1][0]==enamel:               
                data_return.append(data[0])
                data_return.append(data[i])
        if data_return==[]:
            print('ERROR: Insulation system not found')

        self.coil_insulation_system=data_return

        #READ INSULATION MATERIAL DATA
        for i in range(len(data_return[1])):
            if len(data_return[1][i])>1:    #check if it is insulation material or configuration variable
                ins_name=data_return[0][i]

                file = open(self.insulation_database_directory+'\\'+ins_name+'.txt', "r")
                for line in file:
                    if line[0]=='#' or line[0]=='':
                        pass
                    else:
                        sep=[]
                        [sep.append(i) for i in range(len(line)) if line[i]==',']
                        value=eval(line[0:sep[0]].strip())
                        try:
                            parameter_name=line[sep[0]+1:sep[1]].strip()
                        except:
                            print('WARNING: no descripion in insulation material file:' +ins_name)
                            parameter_name=line[sep[0]+1::].strip()
                        
                        vars(self)['ins_'+ins_name+'_'+parameter_name]=value                        
                   
                file.close()
        



class General(Main_collection):
    def __init__(self,path_to_programm,path_to_control_file):        
        super().__init__(path_to_programm,path_to_control_file)
        self.class_name='General'
        self.prename='M_GE'

        #COLLECT DATA and REMOVE DOUBLE ENTRIES
        self.read_input_data()          #self.input_data
        #READ CLASS INFO FILE
        self.read_class_info_file()     #self.input_parameter_declaration   self.input_function_required 
        #CHECK DATA and ADD DESCRIPTION
        self.check_extend_input()       #self.data_collected
        #CREATE VARIABLES
        self.create_variables(self.data_collected)

         
class Coil(Main_collection):
    def __init__(self,path_to_programm,path_to_control_file): 
        super().__init__(path_to_programm,path_to_control_file)
        self.class_name='Coil'
        self.prename='M_ST_COIL'

        #COLLECT DATA and REMOVE DOUBLE ENTRIES
        self.read_input_data()          #self.input_data
        #READ CLASS INFO FILE
        self.read_class_info_file()     #self.input_parameter_declaration   self.input_function_required 
        #CHECK DATA and ADD DESCRIPTION
        self.check_extend_input()       #self.data_collected 
        #CREATE VARIABLES
        self.create_variables(self.data_collected)


    def calculate_coil_parameters_OLD(self,data_pool):             
        function_name='calculate_coil_parameters_OLD'
        test=self.import_function_data(data_pool,function_name)        
        self.create_variables(test)

        self.get_material('Copper')
        mat_Copper_gamma20=self.mat_Copper_gamma20
        mat_Copper_alpha=self.mat_Copper_alpha
        mat_Copper_mur=self.mat_Copper_mur
        mat_Copper_gamma=self.mat_Copper_gamma
        mat_Copper_Price_pu=self.mat_Copper_Price_pu



        self.get_insulation()
        ins_HPMP_width=self.ins_HPMP_width
        ins_HPMP_gamma=self.ins_HPMP_gamma
        ins_HPMP_Price_pu=self.ins_HPMP_Price_pu
        ins_LMP_width=self.ins_LMP_width
        ins_LMP_gamma=self.ins_LMP_gamma
        ins_PF_width=self.ins_PF_width
        ins_PF_gamma=self.ins_PF_gamma
        ins_TPFL_width=self.ins_TPFL_width
        ins_TPFL_gamma=self.ins_TPFL_gamma
        ins_TPFL_Price_pu=self.ins_TPFL_Price_pu        
        ins_SPGF_width=self.ins_SPGF_width
        ins_SPGF_gamma=self.ins_SPGF_gamma
        ins_SPGF_Price_pu=self.ins_SPGF_Price_pu        

        import string
        ### INITIALIZATION
        insulation_database_directory=self.insulation_database_directory   
        #material_database_director=self.material_database_director

        M_ST_COIL_n_W_turns=self.n_W_turns
        M_ST_COIL_l_ST=self.l_fe
        M_ST_COIL_l_copper_h=self.l_copper_h
        
        M_ST_LAM_l_Z2_bn=self.l_Z2_bn-self.l_slot_clearance_h
        M_ST_LAM_l_Z2_hn=self.l_Z2_hn
        M_ST_LAM_w_Z1_Tau_Z=self.w_Z1_Tau_Z
        M_ST_LAM_r_airgap=self.r_airgap        

        M_ST_COIL_n_parallels=self.n_parallels_h   
        M_ST_COIL_n_IS_layers=self.n_IS_layers

        M_ST_COIL_l_terminal=self.l_terminal
        M_ST_COIL_l_str_ew=self.l_str_ew
        M_ST_COIL_l_lug=self.l_lug   


        M_ST_COIL_l_copper_w=[]
        for i in range(1,100):
            try:
                #w_temp=self.find_parameter_entry(self.data_collected,'l_copper_w'+str(i))[1]  
                w_temp=vars(self)['l_copper_w'+str(i)]
                M_ST_COIL_l_copper_w.append(w_temp)  
            except:
                break
        
       
        machine_size=self.standard_machine
        copper_file_name='copper'

        adapt_copper_height=1

        path_to_machine=self.path_to_machine
        output_folder=path_to_machine
        #S_OP_ST_temperature=self.find_parameter_entry(self.input_data_collected,'M_GE_ST_temperature')[1]
        S_OP_ST_temperature=self.st_temperature
        ###

                
        class Get_Ins_Data():

            def __init__(self,File):
                
                #Reading the first *.n_types columns and storing the row's number into parameter k
                #from Insulation_calc2 import ins_type
                self.n_types=len(ins_type)  
                ins_type_check=np.delete(np.loadtxt(insulation_database_directory+'\\'+File,skiprows=1, delimiter='-', comments='#'), np.s_[self.n_types:],1)

                self.k=0
                for i in range(np.shape(ins_type_check)[0]):
                    self.k+=1
                    if np.array_equal(ins_type,ins_type_check[i])==True:
                        break
                self.k-=1
                    
                with open(insulation_database_directory+'\\'+File) as file:
                    self.Names_abbr=[str(i).strip() for i in file.readlines()[0].split('-')][self.n_types:]
                    
                data1=np.genfromtxt(insulation_database_directory+'\\'+File, skip_header=1, delimiter='-', comments='#')[self.k][self.n_types:]
                self.Ins_data=[data1[i:i+6] for i in range(0,42,6)]         
                
            def get_Names_abbr(self):
                return self.Names_abbr

            def get_k(self):
                return self.k
                
            def get_n_types(self):
                return self.n_types

            def get_Ins_Data(self):
                return self.Ins_data
                
        class Get_Coil_Chars():
            
            def __init__(self,File):
                self.Data=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#')
                self.row=[]
                i=1
                j=0
                for line in self.Data:
                    if line==str(i):
                        self.row.append(j)
                        i+=1
                    j+=1
                self.row.append(len(self.Data))
            
            def get_Data(self):
                return self.Data
                
            def get_row(self):
                return self.row 
                
                
        class Get_Geometry_Coil():
            
            def __init__(self):

                data_required=[]
                data_required.append(['Gap_top',float(0),'gap coil top'])
                data_required.append(['Gap_wedge',float(0),'clearence due to presence of wedge, 0 if no wedge exists'])
                data_required.append(['ST_l',M_ST_COIL_l_ST,'active length'])
                data_required.append(['ST_WI_W1_n',M_ST_COIL_n_W_turns,'nr. of turns'])
                data_required.append(['ST_BL_Z2_hn',M_ST_COIL_n_W_turns,'slot height'])

                self.Values=[]
                self.Names=[]
                self.Desc=[]
                for i in range(len(data_required)):
                    self.Names.append(data_required[i][0])
                    self.Values.append(data_required[i][1])
                    self.Desc.append(data_required[i][2])
                
                self.Names=np.array(self.Names)
                self.Values=np.array(self.Values)
                self.Desc=np.array(self.Desc)                
                # if machine_size=='D2_2_Standard':
                    # File='Geometry_Coil_D2.2.txt'
                # elif machine_size=='D3_0_Standard':
                    # File='Geometry_Coil_D3.0.txt'
                # elif machine_size=='D4_1_Standard':
                    # File='Geometry_Coil_D4.1.txt'
                    
                # # Getting informations on the Coil and slot characteristics   
                # self.Values=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('f8'), comments='#', usecols=0)
                # self.Names=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=1)
                # self.Desc=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=2)
                
                self.Data_all=np.column_stack((self.Names, self.Desc))

            def get_Data_all(self):
                #return the matrix comprising all data being read from "File1"
                return self.Data_all
            def get_Data_values(self):
                return self.Values
            def get_Data_desc(self):
                return self.Values
            def get_Data_names(self):
                return self.Values
                
            def get_Slot_height(self):
                # return the slot's height value in [mm]
                k=int(np.where(self.Names=='ST_BL_Z2_hn')[0][0])
                return self.Values[k]
                
            def get_Slot_width(self):
                # return the slot's width value in [mm]
                k=int(np.where(self.Names=='ST_BL_Z2_bn')[0][0])
                return self.Values[k]
            
            def get_Clearence(self):
                # return the radial dimension of the gap existing btw the air-gap and the top of the winding in [mm]
                k=int(np.where(self.Names=='Gap_top')[0][0])
                return self.Values[k]

            def get_l_lam(self):
                # return the radial dimension of the gap existing btw the air-gap and the top of the winding in [mm]
                k=int(np.where(self.Names=='ST_l')[0][0])
                return self.Values[k]
            
            def get_Wedge(self):
                # return the radial dimension of the gap due to the presence of the wedge in [mm]
                k=int(np.where(self.Names=='Gap_wedge')[0][0])
                return self.Values[k]
            
            def get_Number_turns(self):
                # return the number of turns the winding consists of (set by the user)
                k=int(np.where(self.Names=='ST_WI_W1_n')[0][0])
                #k=
                return self.Values[k]
                
            def get_Number_parallel(self):
                # return the number of parallel paths the winding is made of (set by the user)
                k=int(np.where(self.Names=='ST_WI_W1_a')[0][0])
                return self.Values[k]
                
            def get_Number_IS(self):
                # return the number of extra-insulation's layers (set by the user)
                k=int(np.where(self.Names=='n_IS')[0][0])
                return self.Values[k]
            
            def get_r_gap(self):
                k=int(np.where(self.Names=='ST_BL_r_G')[0][0])
                return self.Values[k]
                
            def get_slot_pitch(self):
                k=int(np.where(self.Names=='ST_BL_Z1_Tau_Z')[0][0])
                return self.Values[k]

            def get_terminals_l(self):
                k=int(np.where(self.Names=='WI_terminal_l')[0][0])
                return self.Values[k]
                
            def get_straight_ew(self):
                k=int(np.where(self.Names=='WI_str_ew')[0][0])
                return self.Values[k]   
                
            def get_lug_l(self):
                k=int(np.where(self.Names=='WI_lug_l')[0][0])
                return self.Values[k]

            def get_n_IS(self):
                k=int(np.where(self.Names=='n_IS')[0][0])
                return self.Values[k]


        class Get_Material_Data():

            def __init__(self, File):

                # Getting informations on the Coil and slot characteristics 
                self.Values=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('f8'), comments='#', usecols=0)
                self.Names=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=1)
                self.Desc=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=2)

                ###correct copper parameters from machine (not from coil calc)

                
                
                if File=='Copper.txt':
                    
                    cfg = configparser.ConfigParser(inline_comment_prefixes=":")
                    cfg.optionxform = lambda option: option
                    f=open(material_database_director+'\\'+copper_file_name+'\\'+copper_file_name+'.txt', "r")
                    cfg.read(material_database_director+'\\'+copper_file_name+'\\'+copper_file_name+'.txt')
                    Names_machine=[]
                    Values_machine=[]
                    for Names_machine,Values_machine in cfg.items('Materialparameter'):
                        if Names_machine=='gamma20':
                            sigma_copper=Values_machine
                        #Names_machine.append(Names_machine)
                        #Values_machine.append(Values_machine)
                        #locals()[str(Names_machine)]=eval(Values_machine)
                    f.close()

                    #self.Values_machine=np.genfromtxt(path_temp+'\\'+copper_file_name+'\\'+copper_file_name+'.txt', delimiter=',',dtype=np.dtype('f8'), comments='#', usecols=0)
                    #self.Names_machine=np.genfromtxt(path_temp+'\\'+copper_file_name+'\\'+copper_file_name+'.txt', delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=1)
                
                    k_copper_sigma_coilcalc=int(np.where(self.Names=='Sigma')[0][0])
                    #k_copper_sigma_machine=int(np.where(Names_machine=='gamma20')[0])
                    self.Values[k_copper_sigma_coilcalc]=sigma_copper        
                    print('loop copper sigma entered',sigma_copper)
                ###
               
                self.Data_all=np.column_stack((self.Names, self.Desc))
                
            def get_Data_all(self):
                return self.Data_all
            def get_Data_values(self):
                return self.Values
            def get_Data_desc(self):
                return self.Values
            def get_Data_names(self):
                return self.Values  
                
            def get_sigma(self):
                k=int(np.where(self.Names=='Sigma')[0][0])
                return self.Values[k]
            
            def get_alpha(self):
                k=int(np.where(self.Names=='Alpha')[0][0])
                return self.Values[k]
                
            def get_mur(self):
                k=int(np.where(self.Names=='mur')[0][0])
                return self.Values[k]

            def get_gamma(self):
                k=int(np.where(self.Names=='gamma')[0][0])
                return self.Values[k]
            
            def get_width(self):
                k=int(np.where(self.Names=='width')[0][0])
                return self.Values[k]   

            def get_price(self):
                k=int(np.where(self.Names=='Price_pu')[0][0])
                return self.Values[k]       
                
        class OP_point():

            def __init__(self):
                
                File='Operation_point.txt'
                
                #self.get_Data(insulation_database_directory, File)

            def get_Data(self, insulation_database_directory, File):
                
                self.Values=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('f8'), comments='#', usecols=0)
                self.Names=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=1)
                self.Desc=np.genfromtxt(insulation_database_directory+'\\'+File, delimiter=',',dtype=np.dtype('U128'), autostrip=True, comments='#', usecols=2)
                
            def get_Data_values(self):
                return self.Values
                
            def get_Data_names(self):
                return self.Desc
                
            def get_Data_names_vars(self):
                return self.Names

            def get_SC_instant(self):
                # Short-circuit instant in [s]
                k=int(np.where(self.Names=='OP_SSC_t')[0])
                return self.Values[k]
                
            def get_t_end(self):
                # Stop-time in [s]
                k=int(np.where(self.Names=='OP_t_end')[0])
                return self.Values[k]
                
            def get_OP_speed(self):
                # Operational speed in [rpm]
                k=int(np.where(self.Names=='OP_speed')[0])
                return self.Values[k]
                
            def get_OP_Torque(self):
                # Torque of the operation point in [kNm]
                k=int(np.where(self.Names=='OP_T')[0])
                return self.Values[k]
                
            def get_J_system(self):
                # Torque of the operation point in [kNm]
                k=int(np.where(self.Names=='OP_J_ges')[0])
                return self.Values[k]
                
            def get_J_machine(self):
                # Torque of the operation point in [kNm]
                k=int(np.where(self.Names=='OP_J_mot')[0])
                return self.Values[k]
                
            def get_OP_f(self):
                # Operation frequency in [Hz]
                k=int(np.where(self.Names=='OP_f')[0][0])
                return self.Values[k]
            
            def get_T_WI(self):
                # Temperature - Stator frame [°C]
                k=int(np.where(self.Names=='OP_T_ST_FR')[0])
                return self.Values[k]
            
            def get_T_SB(self):
                # Temperature - Stator bolts [°C]
                k=int(np.where(self.Names=='OP_T_ST_Bolt')[0])
                return self.Values[k]
            
            def get_T_SW(self):
                # Temperature - Stator winding [°C]
                k=int(np.where(self.Names=='OP_T_ST_Winding')[0][0])
                return self.Values[k]
                
            def get_T_SW_ins(self):
                # Temperature - Stator winfing insulation [°C]
                k=int(np.where(self.Names=='OP_T_ST_Wi_iso')[0])
                return self.Values[k]
                
            def get_T_SL(self):
                # Temperature - Stator lamination [°C]
                k=int(np.where(self.Names=='OP_T_ST_BL')[0])
                return self.Values[k]
                
            def get_T_RF(self):
                # Temperature - Rotor frame [°C]
                k=int(np.where(self.Names=='OP_T_RO_FR')[0])
                return self.Values[k]
                
            def get_T_RC(self):
                # Temperature - Rotor carrier [°C]
                k=int(np.where(self.Names=='OP_T_RO_Ca')[0])
                return self.Values[k]
                
            def get_T_M1(self):
                # Temperature - Magnet 1 [°C]
                k=int(np.where(self.Names=='OP_T_RO_Ma1')[0])
                return self.Values[k]
                
            def get_T_M2(self):
                # Temperature - Magnet 2 [°C]
                k=int(np.where(self.Names=='OP_T_RO_Ma2')[0])
                return self.Values[k]
                
            def get_T_M3(self):
                # Temperature - Magnet 3 [°C]
                k=int(np.where(self.Names=='OP_T_RO_Ma3')[0])
                return self.Values[k]
                
            def get_T_M4(self):
                # Temperature - Magnet 4 [°C]
                k=int(np.where(self.Names=='OP_T_RO_Ma4')[0])
                return self.Values[k]


        ##########
                

        class insulation_calc:

            def __init__(self):
                           
                File='Insulation2.txt'


                
                self.get_Ins_type()
                self.get_Names()
                self.Ins_Data()
                self.Coil_charcs()
                self.write_output(output_folder, File)
            
            def get_Ins_type(self):

                
                """
                With all aquired informations, it provides the value of constant "k", that contains
                the row's number that has to be read (only) accordingly, as well as the number of
                columns to skip.
                
                Arguments:
                    - Folder    Name of the folder where the *.txt-file is stored
                    - File      Name of the *.txt file itself containing all data   
                
                Variables:
                    - *.n_types     Number of types of insulation possible
                    - ins_type      Internal variable into which the actual type of insulation is stored
                    - *.k           Row's number to be read
                    
                """
                File='Insulation2.txt'
                self.k=Get_Ins_Data(File).get_k()
                self.n_types=Get_Ins_Data(File).get_n_types()

            def get_Names(self):
            
                """
                From the *.txt file, this method reads and store the names of the:
                    -   Insulation system's parts
                    -   Insulation system's single constituents
                
                Arguments:
                    - Folder    Name of the folder where the *.txt-file is stored
                    - File      Name of the *.txt file itself containing all data   
                
                Variables:
                    - *.Names_parts     Names of the insulation system's parts
                    - *.Names_all       Names of all insulation system's single constituents
                """     
            
                    
                #Reading material's names of all insulation system constituents
                File='Insulation2.txt'
                self.Names_abbr=Get_Ins_Data(File).get_Names_abbr()
                
                # Functions within the insulation system
                #self.Data_functions=['INTERTURN', 'INTERSTRAND' ,'MAIN-WALL','SLOT LINER','END-WINDING PROTECTION']
                self.Data_functions=['IT', 'IS' ,'MW','SL','EWP']
                
                # Generic names of the insulation system parts
                #self.Data_Names_Gen=['Varnish','Laminated Mica Paper', 'Laminated Mica Paper', 'Highly Porous Mica Paper', 'Three-Ply Flexible Laminate','Polyester felt', 'Shrink Polyester Glass Fibric']
                self.Data_Names_Gen=['Enamel','LMP', 'LMP', 'HPMP', 'TPFL','PF', 'SPGF']
                
                # Description for building the initial table
                self.Data_description=['Number of layers' , 'Overlapping' , 'Unpressed  [mm]' , 'Pressed  [mm]' , 'Tolerance [mm]' , 'Width [mm]']



                self.ftm_Names_Gen=[]
                for i in self.Data_Names_Gen:
                    self.ftm_Names_Gen.append('{:<'+str(len(i)+4)+'}| ')
                    
                self.ftm_description=[]
                for i in self.Data_description:
                    self.ftm_description.append('{:<'+str(len(i)+1)+'}  | ')
                

                self.ftm_functions=['{:^'+str(len(self.Data_Names_Gen[0])+len(self.Data_Names_Gen[1])+11)+'}| ','{:^'+str(len(self.Data_Names_Gen[2])+4)+'}| ','{:^'+str(len(self.Data_Names_Gen[3])+4)+'}| ','{:^'+str(len(self.Data_Names_Gen[4])+len(self.Data_Names_Gen[5])+10)+'}| ','{:^'+str(len(self.Data_Names_Gen[6])+4)+'}| ']
                #self.ftm_functions=['{:^'+str(len(self.Data_functions[0])+5)+'}| ','{:^'+str(len(self.Data_functions[1])+5)+'}| ','{:^'+str(len(self.Data_functions[2])+5)+'}| ','{:^'+str(len(self.Data_functions[3])+5)+'}| ','{:^'+str(len(self.Data_functions[4])+5)+'}| ']


                self.data_Names_parts=['Interturn' , 'Top' , 'Bottom' , 'Side' , 'Interstrand']

                
            def Ins_Data(self):
            
                """
                This method calculates all informations proper of the user-defined insulation systems by means of
                all variables created in 'get_Header'. It also utilizes the values given by the method 'get_Names'
                which are used to provide a description of what each specific quantity is.
                Every variables initialized inside this method is of a mix type, since it contains both one (or more)
                numeric value(s) and the corresponding string.
                
                Required methods:
                    - get_Header
                    - get_Names
                    
                Variables:
                    - *.Ins_Data_all        Contains "number of layers", "value" and "description" of each constituent
                                            of the insulation system. 
                    -*.Ins_Data_parts       Contains "value" and "description" of every part of the insulation system,
                                            not specifing their internal structure
                """     
                File='Insulation2.txt'
                self.Ins_data=Get_Ins_Data(File).get_Ins_Data()
                
                self.Ins_Data_all=np.column_stack((self.Names_abbr,self.Ins_data))
                
                self.Ins_materials=np.zeros(6,dtype={'names':('names', 'values'), 'formats':('U128', 'f8')})
                self.Ins_materials['names']=self.Data_description[0:]
                
                ###--------Interturn Insulation--------###      
                self.Enamel=self.get_Enamel_n()/(1-self.get_Enamel_ol())*self.get_Enamel_th()
                self.LMP_IT=self.get_LMP_IT_n()/(1-self.get_LMP_IT_ol())*self.get_LMP_IT_th()

                self.Enamel_up=self.get_Enamel_n()/(1-self.get_Enamel_ol())*self.get_Enamel_th_up()
                self.LMP_IT_up=self.get_LMP_IT_n()/(1-self.get_LMP_IT_ol())*self.get_LMP_IT_th_up()     
                
                
                ###--------Extra Interstrand Insulation--------###
                self.LMP_IS=self.get_LMP_IS_n()/(1-self.get_LMP_IS_ol())*self.get_LMP_IS_th()       
                self.LMP_IS_up=self.get_LMP_IS_n()/(1-self.get_LMP_IS_ol())*self.get_LMP_IS_th_up()
                
                
                ###--------Main wall Insulation--------###      
                self.HPMP_str=self.get_HPMP_str_n()/(1-self.get_HPMP_str_ol())*self.get_HPMP_str_th()
                self.HPMP_ew=self.get_HPMP_ew_n()/(1-self.get_HPMP_ew_ol())*self.get_HPMP_ew_th()

                self.HPMP_str_up=self.get_HPMP_str_n()/(1-self.get_HPMP_str_ol())*self.get_HPMP_str_th_up()
                self.HPMP_ew_up=self.get_HPMP_ew_n()/(1-self.get_HPMP_ew_ol())*self.get_HPMP_ew_th_up()     
            
            
                ###--------Winding Protection--------###
                self.PF=self.get_PF_n()/(1-self.get_PF_ol())*self.get_PF_th()
                self.TPFL=self.get_TPFL_n()/(1-self.get_TPFL_ol())*self.get_TPFL_th()

                
                self.SPGF=self.get_SPGF_n()/(1-self.get_SPGF_ol())*self.get_SPGF_th()
                
                self.PF_up=self.get_PF_n()/(1-self.get_PF_ol())*self.get_PF_th_up()
                self.TPFL_up=self.get_TPFL_n()/(1-self.get_TPFL_ol())*self.get_TPFL_th_up()
                self.SPGF_up=self.get_SPGF_n()/(1-self.get_SPGF_ol())*self.get_SPGF_th_up()
                
                

                
                """ Insulation parts """
                # Interturn
                self.Ins_IT=self.get_Enamel_value()+self.get_LMP_IT_value()
                self.Ins_IT_up=self.get_Enamel_value_up()+self.get_LMP_IT_value_up()
                
                # Side
                self.Ins_Side=self.get_HPMP_str_value()+self.get_TPFL_value()
                self.Ins_Side_up=self.get_HPMP_str_value_up()+self.get_TPFL_value_up()
                
                # Top
                self.Ins_Top=self.get_HPMP_str_value()+2*self.get_TPFL_value()+self.get_PF_value()
                self.Ins_Top_up=self.get_HPMP_str_value_up()+2*self.get_TPFL_value_up()+self.get_PF_value_up()
                
                # Bottom
                self.Ins_Bottom=self.get_HPMP_str_value()+self.get_TPFL_value()*2
                self.Ins_Bottom_up=self.get_HPMP_str_value_up()+self.get_TPFL_value_up()*2
                

                
            def Coil_charcs(self):

                File='Description.txt'
                Data_Desc=Get_Coil_Chars(File)
                self.Data_Coil_charcs=Data_Desc.get_Data()
                self.row=Data_Desc.get_row()
                
                
            def write_output(self, Folder, File):
                f=open(Folder+'\\'+'Coil.out','w+')
                f.write('\n')
                f.write('COIL CHARACTERISTICS STANDARD FILE'+'\n')
                f.write('==================================\n\n\n')
                
                f.write('1\t COIL CHARACTERISTICS\n')
                f.write(' \t ====================\n')
                f.write('\n')
                
                for i in range(0, len(self.row)-1):
                    for j in range(self.row[i]+1, self.row[i+1]):
                        
                        f.write('{:5}'.format(''))
                        f.write(str(self.Data_Coil_charcs[j]))
                        f.write('\n')
                    f.write('\n')
                f.write('\n')
                
                f.write('{:5}'.format(''))
                f.write('INSULATION DATA TABLE\n\n')

                

                j=0
                f.write('{:23}|'.format(''))
                for i in self.Data_functions:
                    f.write(self.ftm_functions[j].format(i))
                    j+=1
                f.write('{:5}'.format(''))
                #f.write('\n     -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n')
                f.write('\n     ---------------------------------------------------------------------------------------\n')
                
                f.write('{:5}'.format(''))
                f.write(self.ftm_description[2].format('Material'))

                j=0
                for i in self.Data_Names_Gen:
                    f.write(self.ftm_Names_Gen[j].format(i))
                    j+=1
                f.write('\n')       
                for i in range(0,6):
                    f.write('{:5}'.format(''))
                    f.write(self.ftm_description[2].format(self.Data_description[i]))
                    for j in range(0,7):
                        #f.write('{:5}'.format(''))
                        f.write(self.ftm_Names_Gen[j].format(self.Ins_data[j][i]))
                    f.write('\n')
                f.write('\n\n')
                #f.write('INTERTURN INSULATION\n')
                #f.write('{:<20}{:<20.3f}\n'.format('Enamel     [mm]:',self.get_Enamel_value()))
                #f.write('{:<20}{:<20.3f}\n'.format('Samicafilm [mm]:', self.get_LMP_IT_value()))

                #f.write('\n\n')
                #f.write('INTERSTRAND INSULATION FOR CORONA PROTECTION\n')
                #f.write('{:<20}{:<20.4f} Extra layer of protection within strands\n'.format('Samicafilm [mm]:', self.get_LMP_IS_value()))
                
                #f.write('\n\n')
                #f.write('MAIN WALL INSULATION\n')
                #f.write('{:<20}{:<20.3f} Straight part of the coil\n'.format('Samicapor  [mm]:',self.get_HPMP_str_value()))
                #f.write('{:<20}{:<20.3f} End-winding and terminals\n'.format('Samicapor  [mm]:', self.get_HPMP_ew_value()))        
                
                #f.write('\n\n')
                #f.write('WINDING PROTECTION\n')
                #f.write('{:<20}{:<20.3f} At coil\'s air-gap side, straight part only\n'.format('Vlies       [mm]:',self.get_PF_value()))
                #f.write('{:<20}{:<20.3f} At coil\'s air-gap side, straight part only\n'.format('Myoflex     [mm]:', self.get_TPFL_value()))
                #f.write('{:<20}{:<20.3f} Coil wrapped by one turn, with overlapping, of at least 80% of the slot\'s width, at the bottom-side\n'.format('Myoflex     [mm]:', self.get_TPFL_value()))
                #f.write('{:<20}{:<20.3f} End-winding protetion. It has to overlap with the end-winding protection of the straight part\n'.format('Epoflex     [mm]:', self.get_SPGF_value()))      
                
                #f.write('\n\n')
                #f.write('INSULATION PARTS\n')
                #f.write('----------------\n')
                #f.write('{:<20}{:<20}{:<20}{:<20}{:<20}\n'.format('Interturn [mm]', 'Side [mm]' , 'Top [mm]', 'Bottom [mm]', 'Interstrand Extra [mm]'))    
                #f.write('{:<20.3f}{:<20.3f}{:<20.3f}{:<20.3f}{:<20.4f}\n'.format(self.get_Ins_IT(), self.get_Ins_Side(), self.get_Ins_Top(), self.get_Ins_Bottom(), self.get_LMP_IS_value(),))
                #f.write('\n\n')
                #f.close()

            
            """
            All following methods return the hereafter-described quantities:
                -*_all      All informations regarding that material: n° of layers, thickness, description
                -*_th       Thickness 
                -*_n        Number of layers
                -*_value    Value=Thickness * Number of layers
            """
            
            def get_Ins_Data_all(self):
                return self.Ins_Data_all        
            def get_Ins_Data_parts(self):
                return self.Ins_Data_parts  
            def get_Values_parts(self):
                return self.Values_parts    

                
            def get_Ins_IT(self):
                return self.Ins_IT
            def get_Ins_IT_up(self):
                return self.Ins_IT_up
            def get_Ins_Side(self):
                return self.Ins_Side
            def get_Ins_Side_up(self):
                return self.Ins_Side_up
            def get_Ins_Top(self):
                return self.Ins_Top
            def get_Ins_Top_up(self):
                return self.Ins_Top_up              
            def get_Ins_Bottom(self):
                return self.Ins_Bottom
            def get_Ins_Bottom_up(self):
                return self.Ins_Bottom_up
                

            # Enamel insulation for the copper strands
            def get_Enamel_all(self):
                self.Ins_materials['values']=self.Ins_data[0]
                return self.Ins_materials           
            def get_Enamel_n(self):
                return self.Ins_data[0][0]
            def get_Enamel_ol(self):
                return self.Ins_data[0][1]
            def get_Enamel_th_up(self):
                return self.Ins_data[0][2]  
            def get_Enamel_th(self):
                return self.Ins_data[0][3]
            def get_Enamel_tol(self):
                return self.Ins_data[0][4]
            def get_Enamel_w(self):
                return self.Ins_data[0][5]
            def get_Enamel_value(self):
                return self.Enamel
            def get_Enamel_value_up(self):
                return self.Enamel_up

                
            # Samicafilm insulation for the copper strands
            def get_LMP_IT_all(self):
                self.Ins_materials['values']=self.Ins_data[1]
                return self.Ins_materials           
            def get_LMP_IT_n(self):
                return self.Ins_data[1][0]
            def get_LMP_IT_ol(self):
                return self.Ins_data[1][1]
            def get_LMP_IT_th_up(self):
                return self.Ins_data[1][2]  
            def get_LMP_IT_th(self):
                return self.Ins_data[1][3]
            def get_LMP_IT_tol(self):
                return self.Ins_data[1][4]
            def get_LMP_IT_w(self):
                return self.Ins_data[1][5]
            def get_LMP_IT_value(self):
                return self.LMP_IT  
            def get_LMP_IT_value_up(self):
                return self.LMP_IT_up   

            #Extra layers of Samicafilm - Interstrand 
            def get_LMP_IS_all(self):
                self.Ins_materials['values']=self.Ins_data[2]
                return self.Ins_materials           
            def get_LMP_IS_n(self):
                return self.Ins_data[2][0]
            def get_LMP_IS_ol(self):
                return self.Ins_data[2][1]
            def get_LMP_IS_th_up(self):
                return self.Ins_data[2][2]  
            def get_LMP_IS_th(self):
                return self.Ins_data[2][3]
            def get_LMP_IS_tol(self):
                return self.Ins_data[2][4]
            def get_LMP_IS_w(self):
                return self.Ins_data[2][5]
            def get_LMP_IS_value(self):
                return self.LMP_IS
            def get_LMP_IS_value_up(self):
                return self.LMP_IS_up
                
            # Samicapor of tha main-wall insulation - straight part of the coil
            def get_HPMP_str_all(self):
                self.Ins_materials['values']=self.Ins_data[3]
                return self.Ins_materials           
            def get_HPMP_str_n(self):
                return self.Ins_data[3][0]
            def get_HPMP_str_ol(self):
                return self.Ins_data[3][1]
            def get_HPMP_str_th_up(self):
                return self.Ins_data[3][2]  
            def get_HPMP_str_th(self):
                return self.Ins_data[3][3]
            def get_HPMP_str_tol(self):
                return self.Ins_data[3][4]
            def get_HPMP_str_w(self):
                return self.Ins_data[3][5]
            def get_HPMP_str_value(self):
                return self.HPMP_str
            def get_HPMP_str_value_up(self):
                return self.HPMP_str_up
                
            # Myoflex as slot liner
            def get_TPFL_all(self):
                self.Ins_materials['values']=self.Ins_data[4]
                return self.Ins_materials           
            def get_TPFL_n(self):
                return self.Ins_data[4][0]
            def get_TPFL_ol(self):
                return self.Ins_data[4][1]
            def get_TPFL_th_up(self):
                return self.Ins_data[4][2]  
            def get_TPFL_th(self):
                return self.Ins_data[4][3]
            def get_TPFL_tol(self):
                return self.Ins_data[4][4]
            def get_TPFL_w(self):
                return self.Ins_data[4][5]
            def get_TPFL_value(self):
                return self.TPFL
            def get_TPFL_value_up(self):
                return self.TPFL_up

                
            #Vlies feltro for winding protection (top of coil)
            def get_PF_all(self):
                self.Ins_materials['values']=self.Ins_data[5]
                return self.Ins_materials           
            def get_PF_n(self):
                return self.Ins_data[5][0]
            def get_PF_ol(self):
                return self.Ins_data[5][1]
            def get_PF_th_up(self):
                return self.Ins_data[5][2]  
            def get_PF_th(self):
                return self.Ins_data[5][3]
            def get_PF_tol(self):
                return self.Ins_data[5][4]
            def get_PF_w(self):
                return self.Ins_data[5][5]
            def get_PF_value(self):
                return self.PF
            def get_PF_value_up(self):
                return self.PF_up
            
            #Samicapor of the main wall insulation - end-winding and terminal protection
            def get_HPMP_ew_all(self):
                self.Ins_materials['values']=self.Ins_data[3]
                return self.Ins_materials           
            def get_HPMP_ew_n(self):
                return self.Ins_data[3][0]
            def get_HPMP_ew_ol(self):
                return self.Ins_data[3][1]
            def get_HPMP_ew_th_up(self):
                return self.Ins_data[3][2]  
            def get_HPMP_ew_th(self):
                return self.Ins_data[3][3]
            def get_HPMP_ew_tol(self):
                return self.Ins_data[3][4]
            def get_HPMP_ew_w(self):
                return self.Ins_data[3][5]
            def get_HPMP_ew_value(self):
                return self.HPMP_ew
            def get_HPMP_ew_value_up(self):
                return self.HPMP_ew_up
                
                
            # Epoflex for End-winding protecition 
            def get_SPGF_all(self):
                self.Ins_materials['values']=self.Ins_data[6]
                return self.Ins_materials           
            def get_SPGF_n(self):
                return self.Ins_data[6][0]
            def get_SPGF_ol(self):
                return self.Ins_data[6][1]
            def get_SPGF_th_up(self):
                return self.Ins_data[6][2]  
            def get_SPGF_th(self):
                return self.Ins_data[6][3]
            def get_SPGF_tol(self):
                return self.Ins_data[6][4]
            def get_SPGF_w(self):
                return self.Ins_data[6][5]
            def get_SPGF_value(self):
                return self.SPGF
            def get_SPGF_value_up(self):
                return self.SPGF_up
                
                
        ############################################################## Coil_calc_2D


        class Coil_calc_2D():
            
            def __init__(self):
                """
                This __init__ method, which is run automatically immediately after the class 'Coil_calc_2D' is called,
                provide the name of the *.txt file that has to be read by the program to retrieve all informations 
                needed to perform the calculation of the coil's strand cross section dimensions.
                It also contains the commands for running all other methodes of this file.
                
                Variables:
                    - Folder2D   Name of the folder where the *.txt-file is stored
                    - File2D      Name of the *.txt file itself containing all data
                
                
                """
                File='Geometry_Settings_XY.txt'
                
                self.strand_calc()
                self.winding_calc()
                self.write_output(output_folder)

                
            def strand_calc(self):
            
                """
                This method computes the copper-strand dimensions, both height and width, starting from:
                
                    1- The data contained in *.Coil_Data_values. All variables needed are set by calling the corresponding
                       method and not the *.Coil_Data_values directly.
                       
                    2- The values of the insulation systems calculated in the python script "Insulation_calc.py" 
                
                Variables:
                    - *.h_strand            Strand's height
                    - *.w_strand            Strand's width
                    
                Before performing any calculation, the method carries out a re-naming of variables for a better handling. 
                This step is not necessary, but it provides a clearer understanding of what will be done in the following 
                lines of code.
                """
            
                
                # Re-naming variables
                self.h=M_ST_LAM_l_Z2_hn
                self.w=M_ST_LAM_l_Z2_bn
                #self.gap_top=Geom_Data_Coil.get_Clearence()
                #self.wedge_dim=Geom_Data_Coil.get_Wedge()
                self.gap_top=Geom_Data_Coil.get_Clearence()
                self.wedge_dim=Geom_Data_Coil.get_Wedge()
                self.n_t=M_ST_COIL_n_W_turns
                #self.n_p=Geom_Data_Coil.get_Number_parallel()
                self.n_p=M_ST_COIL_n_parallels

                
                # Pressed dimensions
                self.n_IS=Ins_Data.get_LMP_IS_n()
                self.Ins_IT=Ins_Data.get_Ins_IT()

                self.Ins_Top=Ins_Data.get_Ins_Top()
                self.Ins_Bottom=Ins_Data.get_Ins_Bottom()
                self.Ins_Side=Ins_Data.get_Ins_Side()
                self.LMP_IS=Ins_Data.get_LMP_IS_value()
                self.HMPM_th=Ins_Data.get_HPMP_str_value()
                self.TPFL_th=Ins_Data.get_TPFL_value()
                self.PF_th=Ins_Data.get_PF_value()
                self.SPGF_th=Ins_Data.get_SPGF_value()

                #Unpressed dimensions
                self.Ins_IT_up=Ins_Data.get_Ins_IT_up()
                self.Ins_Top_up=Ins_Data.get_Ins_Top_up()
                self.Ins_Bottom_up=Ins_Data.get_Ins_Bottom_up()
                self.Ins_Side_up=Ins_Data.get_Ins_Side_up()
                self.LMP_IS_up=Ins_Data.get_LMP_IS_value_up()       
                self.HMPM_th_up=Ins_Data.get_HPMP_str_value_up()
                self.TPFL_th_up=Ins_Data.get_TPFL_value_up()
                self.PF_th_up=Ins_Data.get_PF_value_up()
                self.SPGF_th_up=Ins_Data.get_SPGF_value_up()

                
                #Three-ply
                self.Tply_w=2*self.TPFL_th
                self.Tply_h=4*self.TPFL_th
                
                self.Tply_w_up=2*self.TPFL_th_up
                self.Tply_h_up=4*self.TPFL_th_up        
                
                #Calculation of strand's width and height
                #h_useful=self.h-self.gap_top-self.wedge_dim-8.42
                h_useful=self.h-self.gap_top-self.wedge_dim
                #w_useful=self.w-0.09-0.32
                w_useful=self.w
                #print('w_useful',w_useful)
                #h_useful=self.h-self.gap_top-self.wedge_dim-8.42-0.63
                #w_useful=self.w-0.09
                #self.Ins_IT=self.Ins_IT+(0.22-0.205)
                self.Ins_IT=self.Ins_IT       
                w_p=[]
                w_p=M_ST_COIL_l_copper_w

                # check=[]
                # for i in range(0,int(self.n_p)):
                    # check.append('w_p'+str(i+1))
                    # w_p.append(Geom_Data_Coil.Values[int(np.where(Geom_Data_Coil.Names==check[i])[0][0])])
                self.w_strand=[]
                for i in range(0,int(self.n_p)):
                    #self.w_strand.append(round((w_useful-2*self.Ins_Side-self.Ins_IT*2*self.n_p)/self.n_p*w_p[i]/100,2))
                    self.w_strand.append(round((w_useful-2*self.Ins_Side-self.Ins_IT*2*self.n_p)*w_p[i]/sum(w_p),3))
                    #print(sum(w_p),w_p[i],w_p[i]/sum(w_p))

                #print((w_useful-2*self.Ins_Side-self.Ins_IT*2*self.n_p))
                #print(self.n_p,w_p)
                self.h_strand=round((h_useful-self.Ins_Top-self.Ins_Bottom-self.LMP_IS-self.Ins_IT*2*self.n_t)/self.n_t,4)       
                
                print('copper width: ',self.w_strand)
                print('copper height: ',self.h_strand)
                
                self.r_round_std=[0.5*self.h_strand,0.65,0.80,1]
                
                if self.h_strand<1.00:
                    self.r_round=self.r_round_std[0]
                elif self.h_strand>1.60 and self.h_strand<=2.24:
                    self.r_round=self.r_round_std[1]
                elif self.h_strand>2.24 and self.h_strand<=3.55:
                    self.r_round=self.r_round_std[2]    
                elif self.h_strand>3.55 and self.h_strand<=5.60:
                    self.r_round=self.r_round_std[3]
                else:
                    self.r_round.append(0)
                        
                # Getting the Enamel thickness from insulation_calc()
                Enamel_th=Ins_Data.get_Enamel_value()
                Enamel_th_up=Ins_Data.get_Enamel_value_up()
                
                #Enamelled copper dimensions
                self.w_strand_En=self.w_strand+2*Enamel_th
                self.h_strand_En=self.h_strand+2*Enamel_th

                self.w_strand_En_up=self.w_strand+2*Enamel_th_up
                self.h_strand_En_up=self.h_strand+2*Enamel_th_up

                # Getting the Samicafilm thickness from insulation_calc()
                self.LMP_th=Ins_Data.get_LMP_IS_value()
                self.LMP_th_up=Ins_Data.get_LMP_IS_value_up()

                #Insulated copper dimensions

                self.w_strand_Ins=self.w_strand_En+self.LMP_th
                self.h_strand_Ins=self.h_strand_En+self.LMP_th
                
                self.w_strand_Ins_up=self.w_strand_En_up+self.LMP_th_up
                self.h_strand_Ins_up=self.h_strand_En_up+self.LMP_th_up
                
                #Consolidated coil
                self.w_Coil_Cons=np.sum(self.w_strand_Ins)
                self.h_Coil_Cons=self.n_t*self.h_strand_Ins+self.LMP_IS

                self.w_Coil_Cons_up=np.sum(self.w_strand_Ins_up)
                self.h_Coil_Cons_up=self.n_t*self.h_strand_Ins_up+self.LMP_IS_up
                
                #Insulated coil
                self.w_Coil_Ins=self.w_Coil_Cons+2*self.HMPM_th
                self.h_Coil_Ins=self.h_Coil_Cons+2*self.HMPM_th_up

                self.w_Coil_Ins_up=self.w_Coil_Cons_up+2*self.HMPM_th
                self.h_Coil_Ins_up=self.h_Coil_Cons_up+2*self.HMPM_th_up
                
                #Protected coil
                self.w_Coil_Prot=self.w_Coil_Ins+self.Tply_w
                self.h_Coil_Prot=self.h_Coil_Ins+self.Tply_h+self.PF_th

                self.w_Coil_Prot_up=self.w_Coil_Ins+self.Tply_w_up
                self.h_Coil_Prot_up=self.h_Coil_Ins+self.Tply_h_up+self.PF_th_up
             
            def winding_calc(self):
                self.A_str=[]
                self.A_parallel=[]
                for w in self.w_strand:
                    # Single strand area
                    self.A_str.append(self.h_strand*w-4*np.square(self.r_round)*(1-const.pi/4))
                    #print(self.r_round,'h_strand',self.h_strand)           
                    # Parallel paths area
                    self.A_parallel.append((w*self.h_strand-4*np.square(self.r_round)*(1-const.pi/4))*self.n_t) 

                # Copper Area
                self.A_Cu=np.sum(self.A_parallel)
                
                # Consolidated coil Area
                self.A_Coil_Cons=self.w_Coil_Cons*self.h_Coil_Cons

                # Insulated coil Area
                self.A_Coil_Ins=self.w_Coil_Ins*self.h_Coil_Ins
                
                # Protected coil Area
                self.A_Coil_Prot=self.w_Coil_Prot*self.h_Coil_Prot
                
                # Slot Area
                self.A_Slot=self.w*self.h
                
                # Filling factors
                self.FF_Coil=self.A_Cu/self.A_Coil_Ins
                self.FF_Slot=self.A_Cu/self.A_Slot
                
                
                # PU electrical resistance #
                # ======================== #
                
                #--------------------MATERIAL DATA----------------------#
                #Data_Cu=Get_Material_Data('Copper.txt')
                # Copper conductivity at 20°C
                #self.sigma20_Cu=Data_Cu.get_sigma()
                self.sigma20_Cu=mat_Copper_gamma20
                # Temperature coefficient at 20°C
                #self.alpha_Cu=Data_Cu.get_alpha()
                self.alpha_Cu=mat_Copper_alpha
                # Relative permeability
                #self.mur_Cu=Data_Cu.get_mur()
                self.mur_Cu=mat_Copper_mur
                
                #----------------OPERATING POINT DATA-------------------#
                # Temperature of the stator winding
                #self.OP_T=OP_Data.get_T_SW()
                self.OP_T=S_OP_ST_temperature
                
                # Conductivity at OP_T temperature
                self.sigma_Cu=self.sigma20_Cu/(1+self.alpha_Cu*(self.OP_T-20))
                
                self.R20_Cu_pu=[]
                self.R_Cu_pu=[]     
                for Area in self.A_str:
                    # Per-unit resistance of copper at 20°C
                    self.R20_Cu_pu.append(1/(Area*self.sigma20_Cu)*1000)
                    # Per-unit resistance of copper at OP_T temperature
                    self.R_Cu_pu.append(1/(Area*self.sigma_Cu)*1000)

            def write_output(self, Folder):
                f=open(Folder+'\\'+'Coil.out','a+')
                f.write('2\t CROSS SECTION\n')
                f.write(' \t =============\n')
                f.write('\n')
                f.write('2.1\t Consolidated Coil\n')
                f.write('   \t -----------------\n\n')
                f.write('{:5}{:<15}Enamelled copper wire with insulation tape\n'.format('','Wire:'))
                f.write('{:20}Description file: D10222443\n'.format(''))
                f.write('{:20}Number of turns:               {:<5.0f}\n'.format('', M_ST_COIL_n_W_turns))
                f.write('{:20}Number of parallel strands:   {:<5.0f}\n'.format('', M_ST_COIL_n_parallels))
                f.write('\n')
                f.write('{:20}Laminated mica paper for hot pressing\n'.format(''))
                f.write('{:20}Description file: D10222445\n'.format(''))
                f.write('{:20}Arrangement:  {:<1.0f} + {:<1.0f}  layers \n'.format('', self.n_IS/2, self.n_IS/2 ))
                f.write('{:20}              {:<7.4f}thick unpressed [mm]\n'.format('', Ins_Data.get_LMP_IS_th_up() ))
                f.write('{:20}              {:<7.4f}thick pressed [mm]\n'.format('', Ins_Data.get_LMP_IS_th() ))
                f.write('{:20}              {:<2.0f}%    overlapped\n'.format('',Ins_Data.get_LMP_IS_ol()*100 ))
                f.write('\n')
                for i in range(0,int( M_ST_COIL_n_IS_layers/2)):
                    if i==0:
                        f.write('{:34}Between strands \t[{:<1.0f} and {:<1.0f}]'.format('',i+1,i+2))
                        f.write('\t  and\t [{:<2.0f} and {:<2.0f}]\n'.format(Geom_Data_Coil.get_Number_turns()-i, Geom_Data_Coil.get_Number_turns()-(i+1)))
                    else:
                        f.write('{:34}Between strands \t[{:<1.0f} and {:<1.0f}]'.format('',i+1, i+2))
                        f.write('\t  and\t [{:<2.0f} and {:<2.0f}]\n'.format(Geom_Data_Coil.get_Number_turns()-i, Geom_Data_Coil.get_Number_turns()-(i+1)))
                f.write('\n')
                
                f.write('{:40}{:>18}{:10}{:>18}\n'.format('','Unpressed','','Pressed'))
                f.write('{:40}{:>9}{:>9}{:10}{:>9}{:>9}\n'.format('','width', 'height','', 'width', 'height' ))
                f.write('{:40}{:>9}{:>9}{:10}{:>9}{:>9}\n'.format('','[mm]', '[mm]','', '[mm]', '[mm]' ))
                for i in range(0, int(self.n_p)):
                    f.write('{:20}{:20}\n'.format('','STRAND '+ str(i+1)))
                    f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Bare Copper',self.get_Strand_Bare_widths()[i], self.get_Strand_Bare_height(), '', self.get_Strand_Bare_widths()[i], self.get_Strand_Bare_height() ))
                    f.write('{:20}{:20}{:9}{:>9.2f}\n'.format('','Rounding radius','', self.r_round ))
                    f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Enamelled Copper',self.get_Strand_En_widths_up()[i], self.get_Strand_En_height_up(), '', self.get_Strand_En_widths()[i], self.get_Strand_En_height() ))
                    f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Insulated Copper',self.get_Strand_Ins_widths_up()[i], self.get_Strand_Ins_height_up(), '', self.get_Strand_Ins_widths()[i], self.get_Strand_Ins_height() ))
                    f.write('\n')
                            
                f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Extra interstrand',0, self.LMP_th_up,'', 0, self.LMP_th))
                f.write('\n')
                f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Consolidated coil',self.get_Coil_Cons_width_up(), self.get_Coil_Cons_height_up(), '', self.get_Coil_Cons_width(), self.get_Coil_Cons_height()))
                f.write('\n\n')
                
                f.write('2.2\t Insulated Coil - Straight part\n')
                f.write('   \t ------------------------------\n\n')
                f.write('{:5}Applied to the pressed consolidated coil only.\n\n'.format(''))
                f.write('{:5}{:<15}Highly porous mica paper for VPI\n'.format('','Main-wall:'))
                f.write('{:20}Description file: D10222446\n'.format(''))
                f.write('{:20}{:15}{:<7.0f}layers\n'.format('','Arrangement:',Ins_Data.get_HPMP_str_n() ))
                f.write('{:20}{:15}{:<7.2f}thick [mm]\n'.format('', '',Ins_Data.get_HPMP_str_th() ))
                f.write('{:20}{:15}{:<7.0f}overlapped [%]\n'.format('','',Ins_Data.get_HPMP_str_ol()*100 ))
                f.write('{:20}{:15}At the straight part\n'.format('',''))
                f.write('\n\n')
                
                f.write('2.3\t Insulated Coil - End winding\n')
                f.write('   \t ----------------------------\n\n')
                f.write('{:5}{:<15}Highly porous mica paper for VPI\n'.format('','Main-wall:'))
                f.write('{:20}Description file: D10222446\n'.format(''))
                f.write('{:20}Description file: D10222446\n'.format(''))
                f.write('{:20}{:15}{:<7.0f}layers\n'.format('','Arrangement:',Ins_Data.get_HPMP_ew_n() ))
                f.write('{:20}{:15}{:<7.2f}thick [mm]\n'.format('', '', Ins_Data.get_HPMP_ew_th() ))
                f.write('{:20}{:15}{:<7.0f}overlapped [%]\n'.format('', '',Ins_Data.get_HPMP_ew_ol()*100 ))
                f.write('{:20}{:15}For end-windings and terminals\n'.format('',''))
                f.write('\n')
                
                f.write('{:40}{:28}{:>18}\n'.format('','','Pressed'))
                f.write('{:68}{:>9}{:>9}\n'.format('', 'width', 'height' ))
                f.write('{:68}{:>9}{:>9}\n'.format('', '[mm]', '[mm]' ))
                f.write('\n')
                f.write('{:20}{:48}{:>9.2f}{:>9.2f}\n'.format('','Straight part', 2*self.HMPM_th, 2*self.HMPM_th))
                f.write('\n')
                f.write('{:20}{:48}{:>9.2f}{:>9.2f}\n'.format('','Insulated Coil', self.get_Coil_Ins_width(), self.get_Coil_Ins_height()))
                f.write('\n\n')
                
                
                f.write('2.4\t Protected Coil - Straight part\n')
                f.write('   \t ------------------------------\n\n')
                f.write('{:5}{:<15}'.format('','Slot liner:'))
                if Wedge==0:
                    overlapping='bottom side'
                    f.write('Polyester felt\n'.format(''))
                    f.write('{:20}Description file: D10222448\n'.format(''))
                    f.write('{:20}{:15}{:<7.0f}layers \n'.format('','Arrangement',Ins_Data.get_PF_n() ))
                    f.write('{:20}{:15}{:<7.2f}thick unpressed [mm]\n'.format('', '', Ins_Data.get_PF_th_up() ))
                    f.write('{:20}{:15}{:<7.2f}thick pressed [mm]\n'.format('', '', Ins_Data.get_PF_th() ))
                    f.write('{:20}{:15}{:<7.0f}overlapped [%]\n'.format('','', Ins_Data.get_PF_ol()*100 ))
                    f.write('{:20}{:15}At the coil\'s air-gap side, for the straight part only.\n'.format('',''))
                    f.write('\n')
                    f.write('{:20}'.format(''))
                else:
                    overlapping='top side'
                    
                f.write('Three-ply flexible laminate\n')
                f.write('{:20}Description file: D10222447\n'.format(''))
                f.write('{:20}{:15}'.format('','Arrangement:'))
                if Wedge==0:
                    f.write('{:<7.0f}stratum\n'.format(Ins_Data.get_TPFL_n() ))
                    f.write('{:20}{:15}{:<7.2f}thick [mm]\n'.format('','', Ins_Data.get_TPFL_th() ))
                    f.write('{:20}{:15}At the top side of the coil\n'.format('',''))    
                    f.write('\n')   
                    f.write('{:35}'.format(''))
                f.write('{:<7.0f}layers\n'.format( Ins_Data.get_TPFL_n() ))
                f.write('{:20}{:15}{:<7.2f}thick [mm]\n'.format('','',Ins_Data.get_TPFL_th() ))
                f.write('{:20}{:15}Around the coil\n'.format('',''))    
                f.write('{:20}{:15}Overlapping of at least 80% at the '.format('',''))
                f.write(overlapping+'\n')
                f.write('\n')
                f.write('\n\n')
                
                f.write('{:40}{:>18}{:10}{:>18}\n'.format('','Unpressed','','Pressed'))
                f.write('{:40}{:>9}{:>9}{:10}{:>9}{:>9}\n'.format('','width', 'height','', 'width', 'height' ))
                f.write('{:40}{:>9}{:>9}{:10}{:>9}{:>9}\n'.format('','[mm]', '[mm]','', '[mm]', '[mm]' ))
                f.write('\n')
                f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Three-ply',self.Tply_w_up, self.Tply_h_up,'', self.Tply_w, self.Tply_h))
                
                if Wedge==0:
                    f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Felt', 0, self.PF_th_up, '', 0, self.PF_th))
                f.write('\n')
                f.write('{:20}{:20}{:>9.2f}{:>9.2f}{:10}{:>9.2f}{:>9.2f}\n'.format('','Protected Coil',self.get_Coil_Prot_width_up(), self.get_Coil_Prot_height_up(), '', self.get_Coil_Prot_width(), self.get_Coil_Prot_height()))
                f.write('\n\n')     
                
                f.write('2.5\t Protected Coil - End winding\n')
                f.write('   \t ----------------------------\n\n')
                f.write('{:5}{:<15}Shrink polyester and glass fabric mix\n'.format('','End winding:'))
                f.write('{:20}Description file: D10222449\n'.format(''))
                f.write('{:20}{:15}{:<7.0f}stratum\n'.format('','Arrangement:',Ins_Data.get_SPGF_n() ))
                f.write('{:20}{:15}{:<7.2f}thick [mm]\n'.format('', '',Ins_Data.get_SPGF_th() ))
                f.write('{:20}{:15}{:<7.0f}overlapped [%]\n'.format('','',Ins_Data.get_SPGF_ol()*100 ))     
                f.write('{:20}{:15}For the end-windings and terminals.\n'.format('',''))
                f.write('{:20}{:15}It has to overlap with the protection of the straight part\n'.format('',''))
                f.write('\n')

                f.write('\n\n')
                f.write('2.6\t Strand Resistances\n')
                f.write('   \t ------------------\n\n')

                f.write('{:5}{:<20}Copper conductivity at 20°C:     {:>12.0f}  [S/m]\n'.format('','Material Data:',self.sigma20_Cu))
                f.write('{:25}Temperature coefficient at 20°C: {:>12.5f}  [1/K]\n'.format('',self.alpha_Cu))
                f.write('{:25}Relative permeability of copper: {:>12.0f}\n'.format('',self.mur_Cu))
                f.write('\n\n')


                for i in range(0, int(self.n_p)):
                    f.write('{:5}{:20}\n'.format('','STRAND '+ str(i+1)))
                    f.write('{:5}{:35}{:>8.2f}  [mm2]\n'.format('','Strand  copper area:', self.A_str[i]))
                    f.write('{:5}{:35}{:>8.2f}  [mm2]\n'.format('','Entire parallel path copper area:', self.A_parallel[i]))
                    f.write('{:5}Per-unit resistance at 20°C:{:>15.2f}  [nOhm/mm]\n'.format('',  self.R20_Cu_pu[i]*1e9))
                    f.write('{:5}Per-unit resistance at {:<2.0f}°C:{:>15.2f}  [nOhm/mm]\n'.format('',self.OP_T, self.R_Cu_pu[i]*1e9))           
                    f.write('\n')
                
                
                f.write('{:5}{:20}{:40}{:>8.2f}  [mm2]\n'.format('','Filling factors:','Total slot area:',self.A_Slot))
                f.write('{:25}{:40}{:>8.2f}  [mm2]\n'.format('','Total area of the insulated winding:', self.A_Coil_Ins))
                f.write('{:25}{:40}{:>8.2f}  [mm2]\n'.format('','Total copper area of the winding:', self.A_Cu))

                f.write('{:25}{:40}{:>8.2f}\n'.format('','Winding Filling Factor:', self.FF_Coil))
                f.write('{:25}{:40}{:>8.2f}\n'.format('','Slot Filling Factor:', self.FF_Slot))
                f.write('\n\n')
                
                f.close()


            def get_Strand_Bare_height(self):
                return self.h_strand    
            def get_Strand_Bare_widths(self):
                return self.w_strand

            def get_Strand_En_height(self):
                return self.h_strand_En 
            def get_Strand_En_widths(self):
                return self.w_strand_En

            def get_Strand_En_height_up(self):
                return self.h_strand_En_up  
            def get_Strand_En_widths_up(self):
                return self.w_strand_En_up
                
            def get_Strand_Ins_height(self):
                return self.h_strand_Ins    
            def get_Strand_Ins_widths(self):
                return self.w_strand_Ins

            def get_Strand_Ins_height_up(self):
                return self.h_strand_Ins_up 
            def get_Strand_Ins_widths_up(self):
                return self.w_strand_Ins_up
                
            def get_Coil_Cons_height(self):
                return self.h_Coil_Cons 
            def get_Coil_Cons_width(self):
                return self.w_Coil_Cons
            def get_Coil_Cons_height_up(self):
                return self.h_Coil_Cons_up  
            def get_Coil_Cons_width_up(self):
                return self.w_Coil_Cons_up
                
            def get_Coil_Ins_height(self):
                return self.h_Coil_Ins  
            def get_Coil_Ins_width(self):
                return self.w_Coil_Ins
            def get_Coil_Ins_height_up(self):
                return self.h_Coil_Ins_up   
            def get_Coil_Ins_width_up(self):
                return self.w_Coil_Ins_up
                
            def get_Coil_Prot_height(self):
                return self.h_Coil_Prot 
            def get_Coil_Prot_width(self):
                return self.w_Coil_Prot
            def get_Coil_Prot_height_up(self):
                return self.h_Coil_Prot_up
            def get_Coil_Prot_width_up(self):
                return self.w_Coil_Prot_up
            
            def get_r_round(self):
                return self.r_round
            
            def get_w_Coil_Cons(self):
                return self.w_Coil_Cons
            def get_h_Coil_Cons(self):
                return self.h_Coil_Cons 

            def get_w_Coil_Ins(self):
                return self.w_Coil_Ins
            def get_h_Coil_Ins(self):
                return self.h_Coil_Ins  
                
            def get_A_strand(self):
                return self.A_str   



              ########################### My duty ##############################
  
            def geometry_2d(self):
                # Slot data
                l_Z2_bn = self.l_Z2_bn        # slot width
                l_Z2_hn = self.l_Z2_hn        # slot height
                
                
                #coil data
                if hasattr(self, 'n_parallels_v'):
                     n_parallels_v = self.n_parallels_v    #parallel strands in vertical #***** inja ye chiyi ro nanveshtam (currently 1)
                else:
                     1
                n_parallels_h = self.n_parallels_h    #parallel strands in horizontal
                n_turns = self.n_W_turns              #turns of strands
                
                
                #slot clearance dimensions
                l_slot_clearance_v = self.l_slot_clearance_v   #not usable slot height               
                l_slot_clearance_h = self.l_slot_clearance_h   #not usable slot width
                
                
                #copper width for stand number X
                
            
                copper_wX = getattr(self, 'copper_wX', None)     # check the presented value
                if copper_wX is None:                            # if the value is not presented, the default is 100% or 1 based on word file
                   copper_wX = np.array([1.0])
                else:
                   copper_wX = np.array(copper_wX)
                   
                   
                # Insulation data matrix
                insulation_system = self.coil_insulation_system    # Insulation data
                
                
                #Total available copper width for unpressed condition (my assumption)
                total_copper_width_ratio = np.sum(copper_wX)
                available_width = l_Z2_bn - l_slot_clearance_h  # available sidth for copper
                
                
                #Actual copper widths per strand
                copper_widths = (copper_wX / total_copper_width_ratio) * available_width
                
                
                #copper height and insulated strand height
                
                copper_heights = self.h_strand
                
                
                #Insulation data
                for i in range(0, 5):
                    if insulation_system[1][i][2] != 0:
                       insulation_thickness = insulation_system[1][i][2]          #unpressed insulation thickness         
                    elif insulation_system[1][i][3] != 0:
                       insulation_thickness = insulation_system[1][i][3]                    #pressed insulation thickness

                insulated_strand_heights = copper_heights + 2 * insulation_thickness
                
                
                #Copper rounding radius
                self.r_round_std=[0.5*self.h_strand,0.65,0.80,1]
                
                if self.h_strand<1.00:
                    self.r_round=self.r_round_std[0]
                elif self.h_strand>1.60 and self.h_strand<=2.24:
                    self.r_round=self.r_round_std[1]
                elif self.h_strand>2.24 and self.h_strand<=3.55:
                    self.r_round=self.r_round_std[2]    
                elif self.h_strand>3.55 and self.h_strand<=5.60:
                    self.r_round=self.r_round_std[3]
                else:
                    self.r_round.append(0)
                
                
                
                
                copper_rounding_radius = self.r_round
                
                
                # Data arrasy for horizontal strands(For each strand, store area, width, and insulated width, Copper area with rectangular cross-section
                copper_areas = copper_widths * copper_heights
                insulated_strand_widths = copper_widths + 2 * insulation_thickness
                # For area, assuming rectangular cross-section
                insulated_strand_areas = insulated_strand_widths * insulated_strand_heights
                
                
                # Coil dimensions
                coil_height = max(insulated_strand_heights) * n_parallels_v * n_turns       #coil height
                coil_width = l_Z2_bn - l_slot_clearance_h                                   #coil width (assumption)
                 
                # Coil area
                coil_area = coil_width * coil_height

                # Slot area
                slot_area = l_Z2_bn * l_Z2_hn

                # Filling factors
                total_copper_area = np.sum(copper_areas)
                filling_factor_copper_coil = total_copper_area / coil_area
                filling_factor_copper_slot = total_copper_area / slot_area
                
                
                
                
                # Compile results into a dictionary for output
                results = {
                    'per_strand': {
                    'copper_height': copper_heights,
                    'insulated_strand_height': insulated_strand_heights,
                    'copper_rounding_radius': copper_rounding_radius,
                    'copper_area': copper_areas,
                    'copper_width': copper_widths,
                    'insulated_strand_width': insulated_strand_widths
                         },
                 'coil': {
                    'coil_height': coil_height,
                    'coil_width': coil_width,
                    'coil_area': coil_area,
                    'slot_area': slot_area,
                    'filling_factor_copper_coil': filling_factor_copper_coil,
                    'filling_factor_copper_slot': filling_factor_copper_slot
                        }
                    }

                print(results)
               # Return the results
                return results  

        Milad = geometry_2d()
        print(Milad)  
        
        
        
        
        
        ############################################################## Coil_calc_3D


        class Coil_calc_3D():

            def __init__(self):
                self.get_Data()
                self.Mechanical_calc()
                self.Temperature_corr()
                self.Skin()
                self.Electrical_calc()
                self.write_output(output_folder)
                
            
            def get_Data(self):
            
                '''
                This method simply retrieve the data which are necessary for the computations inside the class
                Variables:
                    - Geom_Data_Coil        Stores all geometrical data of the machine
                    - Data2D        Stores all data calculated in "Coil_calc_2D"            
                '''
                
                #-------------------GEOMETRIC DATA----------------------#
                # Number of parallel strands
                self.n_p=M_ST_COIL_n_parallels
                # Number of turns
                self.n_t=M_ST_COIL_n_W_turns    
                # Slot's width
                self.slot_w=M_ST_LAM_l_Z2_bn
                # Slot's pitch angle 
                self.slot_pitch=M_ST_LAM_w_Z1_Tau_Z
                # Air-Gap radius
                self.r_gap=M_ST_LAM_r_airgap
                # Total lenght of the lamination (active)
                self.l_lam=M_ST_COIL_l_ST
                # Straight part of the end-winding (after the active lenght)
                self.l_str_ew=M_ST_COIL_l_str_ew
                # Lenght of the terminals 
                self.l_term=M_ST_COIL_l_terminal
                # Lenght of the lug 
                self.l_lug=M_ST_COIL_l_lug
                
                
                #-----------------------2D DATA-------------------------#
                # Bare copper widths
                self.w_s=Data2D.get_Strand_Bare_widths()
                # Bare copper height
                self.h_s=Data2D.get_Strand_Bare_height()
                
                self.r_round=Data2D.get_r_round()       
                
                
                #--------------------COPPER DATA----------------------#
                #Data_Cu=Get_Material_Data('Copper.txt')
                # Copper conductivity at 20°C
                #self.sigma20_Cu=Data_Cu.get_sigma()
                self.sigma20_Cu=mat_Copper_gamma20
                # Temperature coefficient at 20°C
                #self.alpha_Cu=Data_Cu.get_alpha()
                self.alpha_Cu=mat_Copper_alpha
                # Relative permeability
                #self.mur_Cu=Data_Cu.get_mur()
                self.mur_Cu=mat_Copper_mur
                # Specific weight in [kg/m3]
                #self.mur_Cu=Data_Cu.get_gamma()
                self.mur_Cu=mat_Copper_gamma
                
                #----------------OPERATING POINT DATA-------------------#
                # Temperature of the stator winding
                #self.OP_T=OP_Data.get_T_SW()
                self.OP_T=-20
                # Frequency of the operation point
                #self.OP_f=OP_Data.get_OP_f()
                self.OP_f=15
            
            def Mechanical_calc(self):
                
                
                # Bending radius
                self.r_bending=round((2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180)-self.slot_w)/2,2)
                
                # Inner diameter of the insulated coil
                self.d_in_ins=round(2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180)-self.slot_w,2)
                
                # Inner diameter of the consolidated coil
                self.d_in_cons=self.d_in_ins+2*Ins_Data.get_Ins_Side()
                
                # Outer diameter of the insulated coil
                self.d_out_ins=self.d_in_ins+2*Data2D.get_w_Coil_Ins()
                
                # Outer diameter of the consolidated coil
                self.d_out_cons=self.d_in_cons+2*Data2D.get_w_Coil_Cons()
            
                
                
                # Mean diameter of each parallel strand [mm]
                self.coil_protect_width=Data2D.get_Coil_Prot_width()
                self.strand_Ins_widths=Data2D.get_Strand_Ins_widths()
                
                self.d=[]
                Ins_temp=self.coil_protect_width-np.sum(self.strand_Ins_widths)     
                self.d.append(2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180)-self.slot_w+Ins_temp+self.strand_Ins_widths[0])
                for i in range(0,int(self.n_p)-1):
                    self.d.append(self.d[i]+self.strand_Ins_widths[i]+self.strand_Ins_widths[i+1])              

                # Mean diameter of each parallel strand [mm]
                # self.d=[]
                # self.d.append(2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180)-self.slot_w+2*self.w_s[0]/2)
                # for i in range(0,int(self.n_p)-1):
                    # self.d.append(self.d[i]+2*self.w_s[i]/2+2*self.w_s[i+1]/2)    


                self.coil_protect_height=Data2D.get_Coil_Prot_height()      
                # print('coil_protect_width',self.coil_protect_width)
                # print('coil_protect_height',self.coil_protect_height)     
                # for i in range(0,len(self.strand_Ins_widths)):
                    # print('strand_Ins_'+str(i+1),self.strand_Ins_widths[i])
                # print('r_gap',self.r_gap)
                # print('slot_pitch',self.slot_pitch)
                # print('slot_w',self.slot_w)
                # for i in range(0,len(self.w_s)):
                    # print('w_s'+str(i+1),self.w_s[i])
                # print('R_middle',2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180))
                # print('R_middle_innen',2*self.r_gap*m.sin(self.slot_pitch/2*const.pi/180)-self.slot_w)
                # print('Inner_cons',self.d_in_cons)
                # print('Outer_cons',self.d_out_cons)
                # print('Middle cons',(self.d_in_cons+self.d_out_cons)/2)
                # #### temporaer
                # self.d=[]
                # self.d.append(43.41)
                # self.d.append(63.15)
                # self.d.append(82.88)
                
                
                # Straight Length
                self.l_straigth=self.l_lam+2*self.l_str_ew

                # Length of the consolidated coil
                self.l_cons=self.l_straigth+self.d[int(self.n_p)-1]+Ins_Data.get_Ins_IT()+2*Ins_Data.get_HPMP_ew_th()
                
                # Length of the Coil
                self.l_coil=self.l_cons+2*Ins_Data.get_SPGF_th()

                # Total length 
                self.l_coil_tot=self.l_straigth+self.d[int(self.n_p)-1]/2+self.l_term+self.l_lug
                


                self.l_ew=[]
                self.l_parallel=[]
                self.l_turn=[]
                self.p_strand=[]
                for i in range(0, int(self.n_p)):
                    self.l_ew.append(const.pi*self.d[i]/2+2*self.l_str_ew)
                    self.l_turn.append(2*(self.l_ew[i]+self.l_lam))
                    self.l_parallel.append((self.l_ew[i]*(2*self.n_t-1)+self.l_lam*2*self.n_t))
                    self.p_strand.append(2*(self.w_s[i]-2*self.r_round+self.h_s-2*self.r_round)+2*const.pi*self.r_round)
                self.l_tot=np.sum(self.l_parallel)+2*self.l_term
                
                self.p_term=2*(np.sum(self.w_s)-2*self.r_round+self.h_s-2*self.r_round)+2*const.pi*self.r_round
                #Data_Enamel=Get_Material_Data('Enamel.txt')
                # width in [mm]
                #w_Enamel=Data_Enamel.get_width()
                # Specific weight in [g/mm2]
                #gamma_Enamel=Data_Enamel.get_gamma()
                
                #Data_Cu=Get_Material_Data('Copper.txt')
                #gamma_Cu=Data_Cu.get_gamma()
                gamma_Cu=mat_Copper_gamma
                
                Data_LMP=Get_Material_Data('LMP.txt')
                # width in [mm]
                #w_LMP=Data_LMP.get_width()
                w_LMP=ins_LMP_width
                # Specific weight in [g/mm2]
                #gamma_LMP=Data_LMP.get_gamma()
                gamma_LMP=ins_LMP_gamma


                Data_HPMP=Get_Material_Data('HPMP.txt')
                # width in [mm]
                #w_HPMP=Data_HPMP.get_width()
                w_HPMP=ins_HPMP_width
                # Specific weight in [g/mm2]
                #gamma_HPMP=Data_HPMP.get_gamma()
                gamma_HPMP=ins_HPMP_gamma

                Data_PF=Get_Material_Data('PF.txt')
                # width in [mm]
                #w_PF=Data_PF.get_width()
                w_PF=ins_PF_width
                # Specific weight in [g/mm2]
                #gamma_PF=Data_PF.get_gamma()
                gamma_PF=ins_PF_gamma
                
                Data_TPFL=Get_Material_Data('TPFL.txt')
                # width in [mm]
                #w_TPFL=Data_TPFL.get_width()
                w_TPFL=ins_TPFL_width
                # Specific weight in [g/mm2]
                #gamma_TPFL=Data_TPFL.get_gamma()
                gamma_TPFL=ins_TPFL_gamma

                Data_SPGF=Get_Material_Data('SPGF.txt')
                # width in [mm]
                #w_SPGF=Data_SPGF.get_width()
                w_SPGF=ins_SPGF_width
                # Specific weight in [g/mm2]
                #gamma_SPGF=Data_SPGF.get_gamma()
                gamma_SPGF=ins_TPFL_gamma
                
                #---- Copper ----#
                self.A_str=Data2D.get_A_strand()
                #self.dim_Cu=np.zeros(4,int(self.n_p))
                self.volume_Cu=[]
                self.weight_Cu=[]
                for i in range(0, int(self.n_p)):
                    #self.dim_Cu[i]=[self.w_s[i], self.h_s, self.r_round, self.l_parallel[i]]
                    self.volume_Cu.append(self.A_str[i]*(self.l_parallel[i]+2*self.l_term))
                    self.weight_Cu.append(self.volume_Cu[i]/1e9*gamma_Cu)       
                self.weight_Cu_tot=np.sum(self.weight_Cu)
                
                #---- Laminated Mica Paper (Interturn) ----#
                self.lenght_LMP=[]
                self.weight_LMP=[]
                self.dim_LMP=np.zeros((int(self.n_p),2))
                ol_LMP=Ins_Data.get_LMP_IT_ol()
                n_LMP=Ins_Data.get_LMP_IT_n()
                for i in range(0, int(self.n_p)):
                    self.lenght_LMP.append(self.p_strand[i]*self.l_parallel[i]/w_LMP/(1-ol_LMP)*n_LMP)
                    self.weight_LMP.append(self.lenght_LMP[i]*w_LMP/1e6*gamma_LMP)
                    self.dim_LMP[i]=[w_LMP, self.lenght_LMP[i]]
                
                
                w_Coil_Cons=Data2D.get_w_Coil_Cons()
                h_Coil_Cons=Data2D.get_h_Coil_Cons()        
                p_Coil_Cons=2*(w_Coil_Cons+h_Coil_Cons)
                
                #---- Laminated Mica Paper (Extra) ----#
                ol_LMP_extra=Ins_Data.get_LMP_IS_ol()
                self.n_LMP_extra=Ins_Data.get_LMP_IS_n()
                
                self.dim_LMP_extra=np.zeros(2)
                self.dim_LMP_extra[0]=w_Coil_Cons
                self.dim_LMP_extra[1]=self.l_lam
                self.weight_LMP_extra=w_Coil_Cons*self.l_lam/1e6*gamma_LMP
                
                self.weight_LMP_tot=np.sum(self.weight_LMP)+self.n_LMP_extra*self.weight_LMP_extra*2
                
                
                #---- Hihly Porous Mica Paper (Straight part) ----#
                ol_HPMP_str=Ins_Data.get_HPMP_str_ol()
                n_HPMP_str=Ins_Data.get_HPMP_str_n()        
                self.dim_HPMP_str=np.zeros(2)
                self.dim_HPMP_str[0]=w_HPMP
                self.dim_HPMP_str[1]=p_Coil_Cons*self.l_lam/w_HPMP/(1-ol_HPMP_str)*n_HPMP_str
                self.weight_HPMP_str=self.dim_HPMP_str[0]*self.dim_HPMP_str[1]/1e6*gamma_HPMP
                
                #---- Hihly Porous Mica Paper (End Winding) ----#
                ol_HPMP_ew=Ins_Data.get_HPMP_ew_ol()
                n_HPMP_ew=Ins_Data.get_HPMP_ew_n()      
                self.dim_HPMP_ew=np.zeros(2)
                self.dim_HPMP_ew[0]=w_HPMP
                self.dim_HPMP_ew[1]=(const.pi*(w_Coil_Cons+52/2)+2*self.l_str_ew)*p_Coil_Cons/w_HPMP/(1-ol_HPMP_ew)*n_HPMP_ew
                self.weight_HPMP_ew=self.dim_HPMP_ew[0]*self.dim_HPMP_ew[1]/1e6*gamma_HPMP
                
                #---- Hihly Porous Mica Paper (Terminal) ----#
                self.dim_HPMP_term=np.zeros(2)
                self.dim_HPMP_term[0]=w_HPMP
                self.dim_HPMP_term[1]=self.l_term*self.p_term/w_HPMP/(1-ol_HPMP_ew)*n_HPMP_ew
                self.weight_HPMP_term=self.dim_HPMP_term[0]*self.dim_HPMP_term[1]/1e6*gamma_HPMP
                
                self.dim_HPMP_tot=np.zeros(2)
                self.dim_HPMP_tot[0]=self.dim_HPMP_term[0]
                self.dim_HPMP_tot[1]=2*(self.dim_HPMP_str[1]+self.dim_HPMP_ew[1]+self.dim_HPMP_term[1])
                self.weight_HPMP_tot=2*(self.weight_HPMP_str+self.weight_HPMP_ew+self.weight_HPMP_term)
                
                
                w_Coil_Ins=Data2D.get_w_Coil_Ins()
                h_Coil_Ins=Data2D.get_h_Coil_Ins()
                p_Coil_Ins=2*(w_Coil_Ins+h_Coil_Ins)
                
                ol_TPFL=Ins_Data.get_TPFL_ol()
                n_TPFL=Ins_Data.get_TPFL_n()        
                
                self.weight_TPFL_tot=0
                
                if Wedge==0:
                    #---- Polyester Felt ----#
                    self.dim_PF=np.zeros(2)
                    self.dim_PF[0]=w_Coil_Cons
                    self.dim_PF[1]=self.l_lam
                    self.weight_PF=self.dim_PF[0]*self.dim_PF[1]/1e6*gamma_PF
                    self.weight_PF_tot=2*self.weight_PF
                    
                    #---- Three-ply Flexible Laminate (top) ----#
                    self.dim_TPFL_top=np.zeros(2)
                    self.dim_TPFL_top[0]=w_Coil_Ins
                    self.dim_TPFL_top[1]=self.l_lam         
                    self.weight_TPFL_top=self.dim_TPFL_top[0]*self.dim_TPFL_top[1]/1e6*gamma_TPFL
                    self.weight_TPFL_tot+=2*self.weight_TPFL_top
                else:
                    self.weight_PF_tot=0

                #---- Three-ply Flexible Laminate ----#
                self.dim_TPFL=np.zeros(2)
                self.dim_TPFL[0]=p_Coil_Ins/(1-ol_TPFL)*n_TPFL+0.8*w_Coil_Ins
                self.dim_TPFL[1]=self.l_lam     
                self.weight_TPFL=self.dim_TPFL[0]*self.dim_TPFL[1]/1e6*gamma_TPFL           
                self.weight_TPFL_tot+=2*self.weight_TPFL
                
                #---- Shrink Polyester Glass Fibric (End Winding)----#
                ol_SPGF=Ins_Data.get_SPGF_ol()
                n_SPGF=Ins_Data.get_SPGF_n()
                self.dim_SPGF_ew=np.zeros(2)
                self.dim_SPGF_ew[0]=w_SPGF
                self.dim_SPGF_ew[1]=(const.pi*(w_Coil_Cons+52/2)+2*self.l_str_ew)*p_Coil_Ins/w_SPGF/(1-ol_SPGF)*n_SPGF  
                self.weight_SPGF_ew=self.dim_SPGF_ew[0]*self.dim_SPGF_ew[1]/1e6*gamma_SPGF      
            
                #---- Shrink Polyester Glass Fibric (Terminal)----#
                ol_SPGF=Ins_Data.get_SPGF_ol()
                n_SPGF=Ins_Data.get_SPGF_n()
                self.dim_SPGF_term=np.zeros(2)
                self.dim_SPGF_term[0]=w_SPGF
                self.dim_SPGF_term[1]=self.l_term*self.p_term/w_SPGF/(1-ol_SPGF)*n_SPGF     
                self.weight_SPGF_term=self.dim_SPGF_term[0]*self.dim_SPGF_term[1]/1e6*gamma_SPGF
                
                self.dim_SPGF_tot=[w_SPGF, self.dim_SPGF_ew[1]+self.dim_SPGF_term[1]]
                self.weight_SPGF_tot=2*(self.weight_SPGF_ew+self.weight_SPGF_term)  
                
                #---- Total Weight ----#
                self.weight_Coil=self.weight_Cu_tot+(self.weight_LMP_tot+self.weight_HPMP_tot+self.weight_PF_tot+self.weight_TPFL_tot+self.weight_SPGF_tot)/1e3

                
            def Temperature_corr(self):
                
                # Conductivity at OP_T temperature
                self.sigma_Cu=self.sigma20_Cu/(1+self.alpha_Cu*(self.OP_T-20))
                
            
            def Skin(self):
                
                # Skin depth at OP_f frequency and 20°C temperature
                self.delta20_Cu=1/m.sqrt(const.pi*self.OP_f*self.sigma20_Cu/1000*const.mu_0/1000*self.mur_Cu)
                # Skin depth at OP_f frequency and OP_T temperature
                self.delta_Cu=1/m.sqrt(const.pi*self.OP_f*self.sigma_Cu/1000*const.mu_0/1000*self.mur_Cu)   
            
                
            def Electrical_calc(self):
                
                #self.R20_Cu_pu=[]
                #self.R_Cu_pu=[]
                self.R_ew_i=[]
                self.R_active_i=[]
                self.R_turn_i=[]
                self.R_ew_tot_i=[]
                self.R_active_tot_i=[]
                self.R_parallel_i=[]
                
                self.R20_Cu_pu=Data2D.R20_Cu_pu
                self.R_Cu_pu=Data2D.R_Cu_pu
                length_test=0
                for i in range(0,int(self.n_p)):
                    # Per-unit resistance of copper at 20°C
                    #self.R20_Cu_pu.append(1/(self.w_s[i]*self.h_s*self.sigma20_Cu)*1000)
                    # Per-unit resistance of copper at OP_T temperature
                    #self.R_Cu_pu.append(1/(self.w_s[i]*self.h_s*self.sigma_Cu)*1000)
                    # End-winding resistance for each parallel strand
                    self.R_ew_i.append(self.R_Cu_pu[i]*self.l_ew[i])
                    # Active straight part resistance for each parallel strand
                    self.R_active_i.append(self.R_Cu_pu[i]*self.l_lam)
                    # Resistance of 1 turn of the coil
                    self.R_turn_i.append(2*(self.R_ew_i[i]+self.R_active_i[i]))
                    #Total end-winding resistance for each parallel path
                    self.R_ew_tot_i.append(self.R_ew_i[i]*(2*self.n_t-1))
                    # Total active length resistance for each parallel path
                    self.R_active_tot_i.append(self.R_active_i[i]*2*self.n_t)
                    #Total resistance for each parallel path
                    self.R_parallel_i.append(self.R_ew_tot_i[i]+self.R_active_tot_i[i])
                    length_test+=self.l_ew[i]*(2*self.n_t-1)+self.l_lam*2*self.n_t  
                
                # Terminals resistance
                w_tot=np.sum(self.w_s)
                R_Cu_pu_term=1/(w_tot*self.h_s*self.sigma_Cu)*1000
                self.R_term=R_Cu_pu_term*(self.l_term*2)
                        
                # End-winding resistance (n_p parallel paths)
                # G_coil=0
                # for i in range(0,int(self.n_p)):
                    # G_coil+=(1/self.R_parallel_i[i])
                
                # Total resistance of the coil
                G_coil=0
                self.R_term_i=[]
                for i in range(0,int(self.n_p)):
                    length_test+=self.l_term*2
                    self.R_term_i.append(self.R_Cu_pu[i]*self.l_term*2)
                    G_coil+=(1/(self.R_parallel_i[i]+self.R_term_i[i]))
                self.R_coil=1/G_coil

                # print('HERE')

                # print('Laenge_Summe',length_test)
                # print('D1',self.d[0])
                # print('D2',self.d[1])
                # print('D3',self.d[2])        

                # print('L Ausleitung sum',self.l_term*2)
                # print('L EW AP SUM Strang 1',self.l_ew[0]*(2*self.n_t-1),self.l_lam*2*self.n_t,self.l_ew[0]*(2*self.n_t-1)+self.l_lam*2*self.n_t+self.l_term*2+2*self.l_str_ew)
                # print('L EW AP SUM Strang 2',self.l_ew[1]*(2*self.n_t-1),self.l_lam*2*self.n_t,self.l_ew[1]*(2*self.n_t-1)+self.l_lam*2*self.n_t+self.l_term*2+2*self.l_str_ew)
                # print('L EW AP SUM Strang 3',self.l_ew[2]*(2*self.n_t-1),self.l_lam*2*self.n_t,self.l_ew[2]*(2*self.n_t-1)+self.l_lam*2*self.n_t+self.l_term*2+2*self.l_str_ew)      

                # print('SUM Strang STRAIGHT',((self.l_lam*2*self.n_t)+(4*self.l_str_ew*self.n_t))*3)           
                # print('SUM Strang 1 EW',((self.l_ew[0]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)) 
                # print('SUM Strang all EW (3)',((self.l_ew[0]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)+((self.l_ew[1]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)+((self.l_ew[2]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)) 
                # print('area copper strand',1/self.R_Cu_pu[0]/1000/self.sigma_Cu)
                # print('sigma_cu',self.sigma_Cu)
                # print('COIL CALCULATION')
                # print('h_s',self.h_s)
                # print('w_s',self.w_s)        
                # print('R_coil',self.R_coil*1000)
                # print('FINAL R',(self.R_coil-0.008466814)/self.R_coil*100)
                # print(((self.l_ew[0]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)+((self.l_ew[1]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)+((self.l_ew[2]-2*self.l_str_ew)*(2*self.n_t-1)+(self.l_term-self.l_str_ew)*2)+((self.l_lam*2*self.n_t)+(4*self.l_str_ew*self.n_t))*3)

                
            def write_output(self, Folder):
                f=open(Folder+'\\'+'Coil.out', 'a+')
                f.write('3\t COMPLETE COIL\n')
                f.write(' \t =============\n')
                f.write('\n')
                f.write('3.1\t Geometrical characteristics\n')
                f.write('   \t ---------------------------\n\n')
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Length of the lamination:',self.l_lam )) 
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Straight part of the end-winding:',self.l_str_ew ))      
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Length of the terminals:',self.l_term )) 
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Length of the terminal lugs:',self.l_lug )) 
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Straight length:',self.l_straigth))
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Straight length - Consolidated Coil:',self.l_cons))
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Coil length:',self.l_coil))
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Total length:',self.l_coil_tot))
                f.write('\n')
                f.write('{:5}{:40}{:>6.0f}  [mm]\n'.format('','Bending Radius:',self.r_bending ))
                f.write('\n')
                f.write('{:5}{:40}{:>6.2f}  [mm]\n'.format('','Inner diameter - Insulated Coil:',self.d_in_ins ))
                f.write('{:5}{:40}{:>6.2f}  [mm]\n'.format('','Inner diameter - Consolidated Coil:',self.d_in_cons ))
                f.write('{:5}{:40}{:>6.2f}  [mm]\n'.format('','Outer diameter - Insulated Coil:',self.d_out_ins ))
                f.write('{:5}{:40}{:>6.2f}  [mm]\n'.format('','Outer diameter - Consolidated Coil:',self.d_out_cons ))  
                f.write('\n\n')
                
                

                f.write('3.2\t Electrical resistance\n')
                f.write('   \t ---------------------\n\n')      
                for i in range(0,int(self.n_p)):
                    f.write('{:5}{:20}\n'.format('','STRAND '+ str(i+1)))
                    f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Single Active-part resistance:',self.R_active_i[i]*1e3 ))
                    f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Single End-winding resistance:',self.R_ew_i[i]*1e3 ))          
                    f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Turn resistance:',self.R_turn_i[i]*1e3 ))
                    f.write('{:5}{:40}{:>6.0f}  \n'.format('','Number of turns:',self.n_t)) 
                    f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Total Active-part resistance:',self.R_active_tot_i[i]*1e3 ))
                    f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Total End-winding resistance:',self.R_ew_tot_i[i]*1e3 ))
                    f.write('{:5}Total resistance of strand {:1}:{:>17.3f}  [mOhm]\n'.format('',i+1,self.R_parallel_i[i]*1e3 ))
                    f.write('\n')
                    
                f.write('{:5}{:20}\n'.format('','TERMINALS'))   
                f.write('{:5}{:40}{:>6.3f}  [mOhm]\n'.format('','Terminals resistance:',self.R_term*1e3 ))
                f.write('\n')
                f.write('\n')
                
                f.write('{:5}{:20}\n'.format('','Total Resistance of one coil'))
                f.write('{:5}{:20}\n'.format('','----------------------------'))
                f.write('{:5}{:5.3f}  [mOhm]\n'.format('',self.R_coil*1e3 ))
                f.write('\n\n')
                
                #f.write('{:5}{:20}\n'.format('','Total Resistance of one winding'))
                #f.write('{:5}{:20}\n'.format('','-------------------------------'))
                #f.write('{:5}{:5.3f}  [mOhm]\n'.format('',self.R_coil*2*1e3 ))


                f.write('3.3\t Materials quantities\n')
                f.write('   \t --------------------\n\n')
                
                n=0     
                n1=string.ascii_lowercase

                f.write('{:5}{:5}{:15}\n'.format('',n1[n]+')','Copper'))
                f.write('{:5}{:5}{:15}\n'.format('','','------'))
                n+=1
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number' ,'Area', 'Length', 'Weight'))
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm2]', '[mm]', '[kg]'))
                for i in range(0, int(self.n_p)):
                    f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.0f}{:>15.2f}\n'.format('','STRAND '+ str(i+1),'1x', self.A_str[i], self.l_parallel[i], self.weight_Cu[i]))
                
                f.write('{:10}'.format(''))
                for i in range(65):
                    f.write('{:1}'.format('_'))
                f.write('\n')
                
                f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '', self.weight_Cu_tot))
                f.write('\n\n') 
                
                f.write('{:5}{:5}{:40}\n'.format('',n1[n]+')','Laminated Mica Paper (LMP)'))
                f.write('{:10}{:40}\n'.format('','-------------------------'))
                n+=1
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number', 'Width', 'Length', 'Weight'))
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm]', '[mm]', '[g]'))
                for i in range(0, int(self.n_p)):
                    f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.0f}{:>15.2f}\n'.format('','STRAND '+ str(i+1), '1x',self.dim_LMP[i][0], self.dim_LMP[i][1],self.weight_LMP[i]))     
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.0f}{:>15.2f}\n'.format('','Extra layer', str(int(2*self.n_LMP_extra))+'x', self.dim_LMP_extra[0],  self.dim_LMP_extra[1], self.weight_LMP_extra))
                
                f.write('{:10}'.format(''))
                for i in range(65):
                    f.write('{:1}'.format('_'))
                f.write('\n')
                
                f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '' , np.sum(self.weight_LMP_tot)))
                f.write('\n\n') 
                
                f.write('{:5}{:5}{:40}\n'.format('',n1[n]+')','Highly Porous Mica Paper (HPMP)'))
                f.write('{:10}{:40}\n'.format('','------------------------------'))
                n+=1
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number', 'Width', 'Length', 'Weight'))
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm]', '[mm]', '[g]'))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Straight','2x', self.dim_HPMP_str[0], self.dim_HPMP_str[1] , self.weight_HPMP_str ))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','End-winding','2x', self.dim_HPMP_ew[0], self.dim_HPMP_ew[1] , self.weight_HPMP_ew ))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Terminal','2x', self.dim_HPMP_term[0], self.dim_HPMP_term[1] , self.weight_HPMP_term ))
                
                f.write('{:10}'.format(''))
                for i in range(65):
                    f.write('{:1}'.format('_'))
                f.write('\n')
                
                f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '' , self.weight_HPMP_tot ))
                f.write('\n\n')
                if Wedge==0:
                    overlapping='Bottom '
                    f.write('{:5}{:5}{:20}\n'.format('',n1[n]+')','Polyester Felt (PF)'))
                    f.write('{:10}{:20}\n'.format('','------------------'))
                    n+=1
                    f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number', 'Width', 'Length', 'Weight'))
                    f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm]', '[mm]', '[g]'))
                    f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Straight','2x', self.dim_PF[0], self.dim_PF[1] , self.weight_PF ))
                    f.write('{:10}'.format(''))
                    for i in range(65):
                        f.write('{:1}'.format('_'))
                    f.write('\n')
                    f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '' , self.weight_PF_tot ))
                    f.write('\n\n')
                else:
                    overlapping='Top'
                f.write('{:5}{:5}{:40}\n'.format('',n1[n]+')','Three-Ply Flexible Laminate (TPFL)'))
                f.write('{:10}{:40}\n'.format('','---------------------------------'))  
                n+=1
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number', 'Width', 'Length', 'Weight'))
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm]', '[mm]', '[g]'))        
                
                if Wedge==0:
                    f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Top Coil','2x', self.dim_TPFL_top[0], self.dim_TPFL_top[1] , self.weight_TPFL_top ))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Around','2x', self.dim_TPFL[0], self.dim_TPFL[1] , self.weight_TPFL))
                
                f.write('{:10}'.format(''))
                for i in range(65):
                    f.write('{:1}'.format('_'))
                f.write('\n')
                
                f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '' , self.weight_TPFL_tot ))
                f.write('\n\n')
                
                f.write('{:5}{:5}{:40}\n'.format('',n1[n]+')','Shrink Polyester and glass fibric mix (SPFG)'))
                f.write('{:10}{:40}\n'.format('','-------------------------------------------'))
                n+=1
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','Number', 'Width', 'Length', 'Weight'))
                f.write('{:10}{:15}{:>10}{:>10}{:>15}{:>15}\n'.format('', '','', '[mm]', '[mm]', '[g]'))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','End winding','2x', self.dim_SPGF_ew[0], self.dim_SPGF_ew[1] , self.weight_SPGF_ew ))
                f.write('{:10}{:15}{:>10}{:>10.2f}{:>15.2f}{:>15.2f}\n'.format('','Terminal','2x', self.dim_SPGF_term[0], self.dim_SPGF_term[1] , self.weight_SPGF_term ))
                
                f.write('{:10}'.format(''))
                for i in range(65):
                    f.write('{:1}'.format('_'))
                f.write('\n')
                
                f.write('{:10}{:15}{:35}{:>15.2f}\n'.format('','Overall', '' , self.weight_SPGF_tot))
                f.write('\n\n')

                f.write('{:5}{:30}\n'.format('','Total Weight'))
                f.write('{:5}{:30}\n'.format('','------------'))    

                f.write('{:5}{:55}{:>15}\n'.format('','','Weight'))
                f.write('{:5}{:55}{:>15}\n'.format('','','[kg]'))
                #f.write('{:5}{:15}{:>10.3f}\n'.format('','Copper',self.weight_Cu_tot))
                #f.write('{:5}{:15}{:>10.3f}\n'.format('','LMP',self.weight_LMP_tot/1e3))
                #f.write('{:5}{:15}{:>10.3f}\n'.format('','HPMP',self.weight_HPMP_tot/1e3))
                #if Wedge==0:
                #   f.write('{:5}{:15}{:>10.3f}\n'.format('','PF',self.weight_PF_tot/1e3))
                #f.write('{:5}{:15}{:>10.3f}\n'.format('','TPFL',self.weight_TPFL_tot/1e3))
                #f.write('{:5}{:15}{:>10.3f}\n'.format('','SPGF',self.weight_SPGF_tot/1e3))
                #f.write('{:5}{:25}\n'.format('','-------------------------',))
                f.write('{:5}{:55}{:>15.3f}\n'.format('','Total Coil weight',self.weight_Coil))
                f.close()
                
                
            def get_R_Cu_pu(self):
                return self.R_Cu_pu

            def get_R_ew(self):
                return self.R_ew
                
            def get_R_active(self):
                return self.R_active
                
            def get_R_Coil(self):
                return self.R_coil
                
            def get_weight_Cu(self):
                return self.weight_Cu_tot
                
            def get_weight_Enamel(self):
                return self.weight_Enamel

            def get_weight_HPMP(self):
                return self.weight_HPMP_tot/1e3
            def get_length_HPMP(self):
                return self.dim_HPMP_tot[1]/1e3
            
            def get_weight_LMP(self):
                return self.weight_LMP_tot/1e3

            def get_weight_PF(self):
                return self.weight_PF_tot/1e3

            def get_weight_SPGF(self):
                return self.weight_SPGF_tot/1e3     
            def get_length_SPGF(self):
                return self.dim_SPGF_tot[1]/1e3
                    
            def get_weight_TPFL(self):
                return self.weight_TPFL_tot/1e3 





              ########################### My duty ##############################

            # def geometry_3d(self):











        ############################################################## Coil_calc_Cost

        class Coil_calc_Costs():

            def __init__(self):
                
                self.get_data()
                self.calc()
                self.write_output(output_folder)
                
                
            def get_data(self):
            
                ######### MATERIAL DATA #########
                ######### ------------- #########
                
                # Copper --> €/100kg
                #Data_Cu=Get_Material_Data('Copper.txt')
                #self.Price_Cu_pu=Data_Cu.get_price()
                self.Price_Cu_pu=mat_Copper_Price_pu
                #self.Price_Cu_pu=Get_Material_Data('Copper.txt').get_price()       
                
                # HPMP --> €/1000m
                #Data_HPMP=Get_Material_Data('HPMP.txt')
                #self.Price_HPMP_pu=Data_HPMP.get_price()
                self.Price_HPMP_pu=ins_HPMP_Price_pu
                #self.Price_HPMP_pu=Get_Material_Data('HPMP.txt').get_price()       
                
                # SPGF --> €/1000m
                #Data_SPGF=Get_Material_Data('SPGF.txt')
                #self.Price_SPGF_pu=Data_SPGF.get_price()
                self.Price_SPGF_pu=ins_SPGF_Price_pu
                #self.Price_SPGF_pu=Get_Material_Data('SPGF.txt').get_price()       
                
                # TPFL --> €/kg
                #Data_TPFL=Get_Material_Data('TPFL.txt')
                #self.Price_TPFL_pu=Data_TPFL.get_price()
                self.Price_TPFL_pu=ins_TPFL_Price_pu
                #self.Price_TPFL_pu=Get_Material_Data('TPFL.txt').get_price()

                ### Weights and lengths ###
                self.w_Cu=Data3D.get_weight_Cu()
                self.l_HPMP=Data3D.get_length_HPMP()
                self.l_SPGF=Data3D.get_length_SPGF()
                self.w_TPFL=Data3D.get_weight_TPFL()
            
            def calc(self):
                
                self.Price_Cu=self.Price_Cu_pu*self.w_Cu/100;
                self.Price_HPMP=self.Price_HPMP_pu*self.l_HPMP/1e3;
                self.Price_SPGF=self.Price_SPGF_pu*self.l_SPGF/1e3;
                self.Price_TPFL=self.Price_TPFL_pu*self.w_TPFL;
                
                self.Price_Coil=self.Price_Cu+self.Price_HPMP+self.Price_SPGF+self.Price_TPFL
                
            
            def write_output(self, Folder):
            
                f=open(Folder+'\\'+'Coil.out', 'a+')
                f.write('\n\n')
                f.write('3.4\t Raw materials costs\n')
                f.write('   \t -------------------\n\n')
                f.write('\n')
                f.write('{:5}{:50}{:>6.2f}  €\n'.format('','Insulated-Enamelled Copper:',self.Price_Cu )) 
                f.write('{:5}{:50}{:>6.2f}  €\n'.format('','Higly Porous Mica Paper:',self.Price_HPMP )) 
                f.write('{:5}{:50}{:>6.2f}  €\n'.format('','Shrink Polyester and Glass Fabric mix:',self.Price_SPGF )) 
                f.write('{:5}{:50}{:>6.2f}  €\n'.format('','Three-Ply Flexible Laminate',self.Price_TPFL ))
                f.write('{:5}'.format(''))
                for i in range(56+3):
                    f.write('{:1}'.format('-'))
                f.write('\n')
                f.write('{:5}{:50}{:>6.2f}  €\n'.format('','Total cost of one coil',self.Price_Coil ))
                f.close()


        Geom_Data_Coil=Get_Geometry_Coil()
        #OP_Data=OP_point()
        # Change parameters
        Geom_Data_Coil.Values[np.where(Geom_Data_Coil.Names=='ST_l')[0]]=M_ST_COIL_l_ST
        Geom_Data_Coil.Values[np.where(Geom_Data_Coil.Names=='ST_WI_W1_n')[0]]=M_ST_COIL_n_W_turns
        #print(Geom_Data_Coil.Values[np.where(Geom_Data_Coil.Names=='Gap_top')[0]])
        adapt_copper_height=1
        if adapt_copper_height==1:
            C=3.91
            par_ins=0.41
            coil_height=C+M_ST_COIL_n_W_turns*(M_ST_COIL_l_copper_h+par_ins)
            #Geom_Data_Coil.Values[0]=95.8005-2.9-coil_height #LGH10-27     
            
            #Geom_Data_Coil.Values[0]=M_ST_LAM_l_Z2_hn-coil_height
            Geom_Data_Coil.Values[np.where(Geom_Data_Coil.Names=='Gap_top')[0][0]]=M_ST_LAM_l_Z2_hn-coil_height
        #print('SOLL',M_ST_LAM_l_Z2_hn-coil_height)
        #print(coil_height)

        ins_type=[]            
        ##########
        Wedge=0
        Enamel=1         
        ins_type.append(Wedge)
        ins_type.append(Enamel)

        Ins_Data=insulation_calc()
        __name__='ins1'
        Data2D=Coil_calc_2D()
        Data3D=Coil_calc_3D()
        CoilCosts=Coil_calc_Costs()

 


    def calculate_coil_parameters(self,data_pool):
        function_name='calculate_coil_parameter'
        test=self.import_function_data(data_pool,function_name)        
        self.create_variables(test)            

        ### Read Material DATA Copper
        self.get_material('Copper')

        ### Read Insulation DATA
        self.get_insulation()


        
        ### Execute functions
        # self.geometry_2d()
        # self.geometry_3d()
        #self.resistance()
        #self.inductance()
        #self.weight()
        #self.cost()


    # def geometry_2d(self):
        
        
        # self.get_TPFL_n()
        # self.coil_insulation_system[1][5][0]
        
        #self.coil_insulation_system[0][i][0]='LMP'
        #self.coil_insulation_system[1][2][0]
        # x 0.. description 1.. correct line  
        # y section horizontal
        # z intersection
        
        ### Examples how to access Machine, Material and Insulation data

        # Example access to machine data    self.mat_MATERIALNAME_PARAMETERNAME
        print('example machine data nr. of turns of the coil: ',self.n_W_turns)       
        # Example access to material data    self.mat_MATERIALNAME_PARAMETERNAME
        print('example material data Copper gamma20: ',self.mat_Copper_gamma20)
        # Example access to insulation general data
        print('example insulation system (data from Insulation2.txt file:', self.coil_insulation_system)
        # Example access to insulation material data    self.ins_MATERIALNAME_PARAMETERNAME
        print('example insulation material data HPMP width: ',self.ins_HPMP_width)

        self.new_example_var=123

    def geometry_3d(self):
        #Example access variable defined in geometry_2d()
        print('"new_example_var" defined in geometry_2d() called from geometry 3d()',self.new_example_var)


       
    # def resistance(self):

    # def inductance(self):
        
    # def cost(self):
        
    # def weight(self):    



       
class Stator_lamination(Main_collection):
    def __init__(self,path_to_programm,path_to_control_file): 
        super().__init__(path_to_programm,path_to_control_file)
        self.class_name='Stator_lamination'
        self.prename='M_ST_LAM'

        #COLLECT DATA and REMOVE DOUBLE ENTRIES
        self.read_input_data()          #self.input_data
        #READ CLASS INFO FILE
        self.read_class_info_file()     #self.input_parameter_declaration   self.input_function_required 
        #CHECK DATA and ADD DESCRIPTION
        self.check_extend_input()       #self.data_collected
        #CREATE VARIABLES
        self.create_variables(self.data_collected)






class Machine():
    def __init__(self):     

        # program path
        path_to_programm=r'C:\temporary\Machine_Calculation_Toolkit'
        path_to_control_file=r'C:\temporary\Machine_Calculation_Toolkit\Machine_Output\Test_machine_generated\Control_file.txt'

        # initialize parts and read data files
        self.M_GE=General(path_to_programm,path_to_control_file)
        self.M_ST_coil=Coil(path_to_programm,path_to_control_file)
        self.M_ST_lam=Stator_lamination(path_to_programm,path_to_control_file)


        # collect data
        self.data_collected=[]
        self.data_collected.extend(self.M_GE.export_all_data(self.M_GE.prename))
        self.data_collected.extend(self.M_ST_coil.export_all_data(self.M_ST_coil.prename))
        self.data_collected.extend(self.M_ST_lam.export_all_data(self.M_ST_lam.prename))

        #print data_collected
        #[print(self.data_collected[i]) for i in range(len(self.data_collected))]

        #run function
        #self.M_ST_coil.calculate_coil_parameters_OLD(self.data_collected)
        self.M_ST_coil.calculate_coil_parameters(self.data_collected)


Maschine=Machine()